<!-- Generated by pkgdown: do not edit by hand -->
<!DOCTYPE html>
<html lang="en">
  <head>
  <meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Image Annotation — anno_image • ComplexHeatmap</title>

<!-- jquery -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js" integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
<!-- Bootstrap -->

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.7/css/bootstrap.min.css" integrity="sha256-916EbMg70RQy9LHiGkXzG8hSg9EdNy97GazNG/aiY1w=" crossorigin="anonymous" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.7/js/bootstrap.min.js" integrity="sha256-U5ZEeKfGNOja007MMD3YBI0A3OSZOQbeG6z2f2Y0hu8=" crossorigin="anonymous"></script>

<!-- Font Awesome icons -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.7.1/css/all.min.css" integrity="sha256-nAmazAk6vS34Xqo0BSrTb+abbtFlgsFK7NKSi6o7Y78=" crossorigin="anonymous" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.7.1/css/v4-shims.min.css" integrity="sha256-6qHlizsOWFskGlwVOKuns+D1nB6ssZrHQrNj1wGplHc=" crossorigin="anonymous" />

<!-- clipboard.js -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/clipboard.js/2.0.4/clipboard.min.js" integrity="sha256-FiZwavyI2V6+EXO1U+xzLG3IKldpiTFf3153ea9zikQ=" crossorigin="anonymous"></script>

<!-- headroom.js -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/headroom/0.9.4/headroom.min.js" integrity="sha256-DJFC1kqIhelURkuza0AvYal5RxMtpzLjFhsnVIeuk+U=" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/headroom/0.9.4/jQuery.headroom.min.js" integrity="sha256-ZX/yNShbjqsohH1k95liqY9Gd8uOiE1S4vZc+9KQ1K4=" crossorigin="anonymous"></script>

<!-- pkgdown -->
<link href="../pkgdown.css" rel="stylesheet">
<script src="../pkgdown.js"></script>



<meta property="og:title" content="Image Annotation — anno_image" />

<meta property="og:description" content="Image Annotation" />
<meta name="twitter:card" content="summary" />



<!-- mathjax -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.5/MathJax.js" integrity="sha256-nvJJv9wWKEm88qvoQl9ekL2J+k/RWIsaSScxxlsrv8k=" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.5/config/TeX-AMS-MML_HTMLorMML.js" integrity="sha256-84DKXVJXs0/F8OTMzX4UR909+jtl4G7SPypPavF+GfA=" crossorigin="anonymous"></script>

<!--[if lt IE 9]>
<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
<![endif]-->



  </head>

  <body>
    <div class="container template-reference-topic">
      <header>
      <div class="navbar navbar-default navbar-fixed-top" role="navigation">
  <div class="container">
    <div class="navbar-header">
      <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false">
        <span class="sr-only">Toggle navigation</span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
      </button>
      <span class="navbar-brand">
        <a class="navbar-link" href="../index.html">ComplexHeatmap</a>
        <span class="version label label-default" data-toggle="tooltip" data-placement="bottom" title="Released version">2.1.0</span>
      </span>
    </div>

    <div id="navbar" class="navbar-collapse collapse">
      <ul class="nav navbar-nav">
        <li>
  <a href="../index.html">
    <span class="fas fa fas fa-home fa-lg"></span>
     
  </a>
</li>
<li>
  <a href="../reference/index.html">Reference</a>
</li>
<li class="dropdown">
  <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">
    Articles
     
    <span class="caret"></span>
  </a>
  <ul class="dropdown-menu" role="menu">
    <li>
      <a href="../articles/complex_heatmap.html">UNKNOWN TITLE</a>
    </li>
    <li>
      <a href="../articles/most_probably_asked_questions.html">UNKNOWN TITLE</a>
    </li>
  </ul>
</li>
      </ul>
      
      <ul class="nav navbar-nav navbar-right">
        <li>
  <a href="https://github.com/jokergoo/ComplexHeatmap">
    <span class="fab fa fab fa-github fa-lg"></span>
     
  </a>
</li>
      </ul>
      
    </div><!--/.nav-collapse -->
  </div><!--/.container -->
</div><!--/.navbar -->

      

      </header>

<div class="row">
  <div class="col-md-9 contents">
    <div class="page-header">
    <h1>Image Annotation</h1>
    
    <div class="hidden name"><code>anno_image.rd</code></div>
    </div>

    <div class="ref-description">
    
    <p>Image Annotation</p>
    
    </div>

    <pre class="usage"><span class='fu'><a href='anno_image.rd.html'>anno_image</a></span>(<span class='no'>image</span>, <span class='kw'>which</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/c.html'>c</a></span>(<span class='st'>"column"</span>, <span class='st'>"row"</span>), <span class='kw'>border</span> <span class='kw'>=</span> <span class='fl'>TRUE</span>,
    <span class='kw'>gp</span> <span class='kw'>=</span> <span class='fu'>gpar</span>(<span class='kw'>fill</span> <span class='kw'>=</span> <span class='fl'>NA</span>, <span class='kw'>col</span> <span class='kw'>=</span> <span class='fl'>NA</span>), <span class='kw'>space</span> <span class='kw'>=</span> <span class='fu'>unit</span>(<span class='fl'>1</span>, <span class='st'>"mm"</span>),
    <span class='kw'>width</span> <span class='kw'>=</span> <span class='kw'>NULL</span>, <span class='kw'>height</span> <span class='kw'>=</span> <span class='kw'>NULL</span>)</pre>
    
    <h2 class="hasAnchor" id="arguments"><a class="anchor" href="#arguments"></a>Arguments</h2>
    <table class="ref-arguments">
    <colgroup><col class="name" /><col class="desc" /></colgroup>
    <tr>
      <th>image</th>
      <td><p>A vector of file paths of images. The format of the image is inferred from the suffix name of the image file. NA values or empty strings in the vector means no image to drawn.</p></td>
    </tr>
    <tr>
      <th>which</th>
      <td><p>Whether it is a column annotation or a row annotation?</p></td>
    </tr>
    <tr>
      <th>border</th>
      <td><p>Wether draw borders of the annotation region?</p></td>
    </tr>
    <tr>
      <th>gp</th>
      <td><p>Graphic parameters for annotation grids. If the image has transparent background, the <code>fill</code> parameter  can be used to control the background color in the annotation grids.</p></td>
    </tr>
    <tr>
      <th>space</th>
      <td><p>The space around the image to the annotation grid borders. The value should be a <code><a href='https://rdrr.io/r/grid/unit.html'>unit</a></code> object.</p></td>
    </tr>
    <tr>
      <th>width</th>
      <td><p>Width of the annotation. The value should be an absolute unit. Width is not allowed to be set for column annotation.</p></td>
    </tr>
    <tr>
      <th>height</th>
      <td><p>Height of the annotation. The value should be an absolute unit. Height is not allowed to be set for row annotation.</p></td>
    </tr>
    </table>
    
    <h2 class="hasAnchor" id="details"><a class="anchor" href="#details"></a>Details</h2>

    <p>This function supports image formats in <code>png</code>, <code>svg</code>, <code>pdf</code>, <code>eps</code>, <code>jpeg/jpg</code>, <code>tiff</code>. 
<code>png</code>, <code>jpeg/jpg</code> and <code>tiff</code> images are imported by <code><a href='https://rdrr.io/pkg/png/man/readPNG.html'>readPNG</a></code>, <code><a href='https://rdrr.io/pkg/jpeg/man/readJPEG.html'>readJPEG</a></code> and 
<code><a href='https://rdrr.io/pkg/tiff/man/readTIFF.html'>readTIFF</a></code>, and drawn by <code><a href='https://rdrr.io/r/grid/grid.raster.html'>grid.raster</a></code>. <code>svg</code> images are firstly reformatted by <code>rsvg::rsvg_svg</code>
and then imported by <code>readPicture</code> and drawn by <code>grid.picture</code>. <code>pdf</code> and <code>eps</code>
images are imported by <code>PostScriptTrace</code> and <code>readPicture</code>, later drawn by <code>grid.picture</code>.</p>
<p>Different image formats can be mixed in the <code>image</code> vector.</p>
    
    <h2 class="hasAnchor" id="value"><a class="anchor" href="#value"></a>Value</h2>

    <p>An annotation function which can be used in <code><a href='HeatmapAnnotation.rd.html'>HeatmapAnnotation</a></code>.</p>
    
    <h2 class="hasAnchor" id="see-also"><a class="anchor" href="#see-also"></a>See also</h2>

    <div class='dont-index'><p><a href='https://jokergoo.github.io/ComplexHeatmap-reference/book/heatmap-annotations.html#image-annotation'>https://jokergoo.github.io/ComplexHeatmap-reference/book/heatmap-annotations.html#image-annotation</a></p></div>
    

    <h2 class="hasAnchor" id="examples"><a class="anchor" href="#examples"></a>Examples</h2>
    <pre class="examples"><div class='input'><span class='co'># download the free icons from https://github.com/Keyamoon/IcoMoon-Free</span>
<span class='kw'>if</span> (<span class='fl'>FALSE</span>) {
<span class='no'>image</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/sample.html'>sample</a></span>(<span class='fu'><a href='https://rdrr.io/r/base/list.files.html'>dir</a></span>(<span class='st'>"~/Downloads/IcoMoon-Free-master/PNG/64px"</span>, <span class='kw'>full.names</span> <span class='kw'>=</span> <span class='fl'>TRUE</span>), <span class='fl'>10</span>)
<span class='no'>anno</span> <span class='kw'>=</span> <span class='fu'><a href='anno_image.rd.html'>anno_image</a></span>(<span class='no'>image</span>)
<span class='fu'><a href='draw-dispatch.rd.html'>draw</a></span>(<span class='no'>anno</span>, <span class='kw'>test</span> <span class='kw'>=</span> <span class='st'>"png"</span>)
<span class='no'>image</span>[<span class='fl'>1</span>:<span class='fl'>5</span>] <span class='kw'>=</span> <span class='st'>""</span>
<span class='no'>anno</span> <span class='kw'>=</span> <span class='fu'><a href='anno_image.rd.html'>anno_image</a></span>(<span class='no'>image</span>)
<span class='fu'><a href='draw-dispatch.rd.html'>draw</a></span>(<span class='no'>anno</span>, <span class='kw'>test</span> <span class='kw'>=</span> <span class='st'>"some of png"</span>)
}</div></pre>
  </div>
  <div class="col-md-3 hidden-xs hidden-sm" id="sidebar">
    <h2>Contents</h2>
    <ul class="nav nav-pills nav-stacked">
      <li><a href="#arguments">Arguments</a></li>
      
      <li><a href="#details">Details</a></li>

      <li><a href="#value">Value</a></li>

      <li><a href="#see-also">See also</a></li>
      
      <li><a href="#examples">Examples</a></li>
    </ul>

  </div>
</div>


      <footer>
      <div class="copyright">
  <p>Developed by Zuguang Gu.</p>
</div>

<div class="pkgdown">
  <p>Site built with <a href="https://pkgdown.r-lib.org/">pkgdown</a> 1.4.1.</p>
</div>

      </footer>
   </div>

  


  </body>
</html>


