<!-- Generated by pkgdown: do not edit by hand -->
<!DOCTYPE html>
<html lang="en">
  <head>
  <meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Constructor Method for SingleAnnotation Class — SingleAnnotation • ComplexHeatmap</title>

<!-- jquery -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js" integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
<!-- Bootstrap -->

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.7/css/bootstrap.min.css" integrity="sha256-916EbMg70RQy9LHiGkXzG8hSg9EdNy97GazNG/aiY1w=" crossorigin="anonymous" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.7/js/bootstrap.min.js" integrity="sha256-U5ZEeKfGNOja007MMD3YBI0A3OSZOQbeG6z2f2Y0hu8=" crossorigin="anonymous"></script>

<!-- Font Awesome icons -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.7.1/css/all.min.css" integrity="sha256-nAmazAk6vS34Xqo0BSrTb+abbtFlgsFK7NKSi6o7Y78=" crossorigin="anonymous" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.7.1/css/v4-shims.min.css" integrity="sha256-6qHlizsOWFskGlwVOKuns+D1nB6ssZrHQrNj1wGplHc=" crossorigin="anonymous" />

<!-- clipboard.js -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/clipboard.js/2.0.4/clipboard.min.js" integrity="sha256-FiZwavyI2V6+EXO1U+xzLG3IKldpiTFf3153ea9zikQ=" crossorigin="anonymous"></script>

<!-- headroom.js -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/headroom/0.9.4/headroom.min.js" integrity="sha256-DJFC1kqIhelURkuza0AvYal5RxMtpzLjFhsnVIeuk+U=" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/headroom/0.9.4/jQuery.headroom.min.js" integrity="sha256-ZX/yNShbjqsohH1k95liqY9Gd8uOiE1S4vZc+9KQ1K4=" crossorigin="anonymous"></script>

<!-- pkgdown -->
<link href="../pkgdown.css" rel="stylesheet">
<script src="../pkgdown.js"></script>



<meta property="og:title" content="Constructor Method for SingleAnnotation Class — SingleAnnotation" />

<meta property="og:description" content="Constructor Method for SingleAnnotation Class" />
<meta name="twitter:card" content="summary" />



<!-- mathjax -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.5/MathJax.js" integrity="sha256-nvJJv9wWKEm88qvoQl9ekL2J+k/RWIsaSScxxlsrv8k=" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.5/config/TeX-AMS-MML_HTMLorMML.js" integrity="sha256-84DKXVJXs0/F8OTMzX4UR909+jtl4G7SPypPavF+GfA=" crossorigin="anonymous"></script>

<!--[if lt IE 9]>
<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
<![endif]-->



  </head>

  <body>
    <div class="container template-reference-topic">
      <header>
      <div class="navbar navbar-default navbar-fixed-top" role="navigation">
  <div class="container">
    <div class="navbar-header">
      <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false">
        <span class="sr-only">Toggle navigation</span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
      </button>
      <span class="navbar-brand">
        <a class="navbar-link" href="../index.html">ComplexHeatmap</a>
        <span class="version label label-default" data-toggle="tooltip" data-placement="bottom" title="Released version">2.1.0</span>
      </span>
    </div>

    <div id="navbar" class="navbar-collapse collapse">
      <ul class="nav navbar-nav">
        <li>
  <a href="../index.html">
    <span class="fas fa fas fa-home fa-lg"></span>
     
  </a>
</li>
<li>
  <a href="../reference/index.html">Reference</a>
</li>
<li class="dropdown">
  <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">
    Articles
     
    <span class="caret"></span>
  </a>
  <ul class="dropdown-menu" role="menu">
    <li>
      <a href="../articles/complex_heatmap.html">UNKNOWN TITLE</a>
    </li>
    <li>
      <a href="../articles/most_probably_asked_questions.html">UNKNOWN TITLE</a>
    </li>
  </ul>
</li>
      </ul>
      
      <ul class="nav navbar-nav navbar-right">
        <li>
  <a href="https://github.com/jokergoo/ComplexHeatmap">
    <span class="fab fa fab fa-github fa-lg"></span>
     
  </a>
</li>
      </ul>
      
    </div><!--/.nav-collapse -->
  </div><!--/.container -->
</div><!--/.navbar -->

      

      </header>

<div class="row">
  <div class="col-md-9 contents">
    <div class="page-header">
    <h1>Constructor Method for SingleAnnotation Class</h1>
    
    <div class="hidden name"><code>SingleAnnotation.rd</code></div>
    </div>

    <div class="ref-description">
    
    <p>Constructor Method for SingleAnnotation Class</p>
    
    </div>

    <pre class="usage"><span class='fu'><a href='SingleAnnotation.rd.html'>SingleAnnotation</a></span>(<span class='no'>name</span>, <span class='no'>value</span>, <span class='no'>col</span>, <span class='no'>fun</span>,
    <span class='kw'>na_col</span> <span class='kw'>=</span> <span class='st'>"grey"</span>,
    <span class='kw'>which</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/c.html'>c</a></span>(<span class='st'>"column"</span>, <span class='st'>"row"</span>),
    <span class='kw'>show_legend</span> <span class='kw'>=</span> <span class='fl'>TRUE</span>,
    <span class='kw'>gp</span> <span class='kw'>=</span> <span class='fu'>gpar</span>(<span class='kw'>col</span> <span class='kw'>=</span> <span class='fl'>NA</span>),
    <span class='kw'>border</span> <span class='kw'>=</span> <span class='fl'>FALSE</span>,
    <span class='kw'>legend_param</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/list.html'>list</a></span>(),
    <span class='kw'>show_name</span> <span class='kw'>=</span> <span class='fl'>TRUE</span>,
    <span class='kw'>name_gp</span> <span class='kw'>=</span> <span class='fu'>gpar</span>(<span class='kw'>fontsize</span> <span class='kw'>=</span> <span class='fl'>12</span>),
    <span class='kw'>name_offset</span> <span class='kw'>=</span> <span class='kw'>NULL</span>,
    <span class='kw'>name_side</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/ifelse.html'>ifelse</a></span>(<span class='no'>which</span> <span class='kw'>==</span> <span class='st'>"column"</span>, <span class='st'>"right"</span>, <span class='st'>"bottom"</span>),
    <span class='kw'>name_rot</span> <span class='kw'>=</span> <span class='kw'>NULL</span>,
    <span class='kw'>simple_anno_size</span> <span class='kw'>=</span> <span class='no'>ht_opt</span>$<span class='no'>simple_anno_size</span>,
    <span class='kw'>width</span> <span class='kw'>=</span> <span class='kw'>NULL</span>, <span class='kw'>height</span> <span class='kw'>=</span> <span class='kw'>NULL</span>)</pre>
    
    <h2 class="hasAnchor" id="arguments"><a class="anchor" href="#arguments"></a>Arguments</h2>
    <table class="ref-arguments">
    <colgroup><col class="name" /><col class="desc" /></colgroup>
    <tr>
      <th>name</th>
      <td><p>Name for the annotation. If it is not specified, an internal name is assigned.</p></td>
    </tr>
    <tr>
      <th>value</th>
      <td><p>A vector or a matrix of discrete or continuous values.</p></td>
    </tr>
    <tr>
      <th>col</th>
      <td><p>Colors corresponding to <code>value</code>. If the mapping is discrete, the value of <code>col</code> should be a named vector; If the mapping is continuous, the value of <code>col</code> should be  a color mapping function.</p></td>
    </tr>
    <tr>
      <th>fun</th>
      <td><p>A user-defined function to add annotation graphics. The argument of this function should be at least  a vector of index that corresponds to rows or columns. Normally the function should be  constructed by <code><a href='AnnotationFunction.rd.html'>AnnotationFunction</a></code> if you want the annotation supports splitting.  See **Details** for more explanation.</p></td>
    </tr>
    <tr>
      <th>na_col</th>
      <td><p>Color for <code>NA</code> values in the simple annotations.</p></td>
    </tr>
    <tr>
      <th>which</th>
      <td><p>Whether the annotation is a row annotation or a column annotation?</p></td>
    </tr>
    <tr>
      <th>show_legend</th>
      <td><p>If it is a simple annotation, whether show legend in the final heatmap?</p></td>
    </tr>
    <tr>
      <th>gp</th>
      <td><p>Since simple annotation is represented as rows of grids. This argument controls graphic parameters for the simple annotation. The <code>fill</code> parameter is ignored here.</p></td>
    </tr>
    <tr>
      <th>border</th>
      <td><p>border, only work for simple annotation</p></td>
    </tr>
    <tr>
      <th>legend_param</th>
      <td><p>Parameters for the legend. See <code><a href='color_mapping_legend-ColorMapping-method.rd.html'>color_mapping_legend,ColorMapping-method</a></code> for all possible options.</p></td>
    </tr>
    <tr>
      <th>show_name</th>
      <td><p>Whether show annotation name?</p></td>
    </tr>
    <tr>
      <th>name_gp</th>
      <td><p>Graphic parameters for annotation name.</p></td>
    </tr>
    <tr>
      <th>name_offset</th>
      <td><p>Offset to the annotation, a <code><a href='https://rdrr.io/r/grid/unit.html'>unit</a></code> object.</p></td>
    </tr>
    <tr>
      <th>name_side</th>
      <td><p>'right' and 'left' for column annotations and 'top' and 'bottom' for row annotations</p></td>
    </tr>
    <tr>
      <th>name_rot</th>
      <td><p>Rotation of the annotation name, it can only take values in <code><a href='https://rdrr.io/r/base/c.html'>c(0, 90, 180, 270)</a></code>.</p></td>
    </tr>
    <tr>
      <th>simple_anno_size</th>
      <td><p>size of the simple annotation.</p></td>
    </tr>
    <tr>
      <th>width</th>
      <td><p>The width of the plotting region (the viewport) that the annotation is drawn. If it is a row annotation, the width must be an absolute unit.</p></td>
    </tr>
    <tr>
      <th>height</th>
      <td><p>The height of the plotting region (the viewport) that the annotation is drawn. If it is a column annotation, the width must be an absolute unit.</p></td>
    </tr>
    </table>
    
    <h2 class="hasAnchor" id="details"><a class="anchor" href="#details"></a>Details</h2>

    <p>A single annotation is a basic unit of complex heatmap annotations where the heamtap annotations
are always a list of single annotations. An annotation can be simply heatmap-like (here we call
it simple annotation) or more complex like points, lines, boxes (for which we call it complex annotation).</p>
<p>In the <code><a href='SingleAnnotation.rd.html'>SingleAnnotation</a></code> constructor, <code>value</code>, <code>col</code>, <code>na_col</code> are used to construct a <code><a href='anno_simple.rd.html'>anno_simple</a></code>
annotation funciton which is generated internally by <code><a href='AnnotationFunction.rd.html'>AnnotationFunction</a></code>. The legend of the simple annotation
can be automatcally generated,</p>
<p>For construcing a complex annotation, users need to use <code>fun</code> which is a user-defind function. Normally it 
is constucted by <code><a href='AnnotationFunction.rd.html'>AnnotationFunction</a></code>. One big advantage for using <code><a href='AnnotationFunction.rd.html'>AnnotationFunction</a></code> is the annotation function
or the graphics drawn by the annotation function can be split according to row splitting or column splitting of
the heatmap. Users can also provide a "pure" function which is a normal R function for the <code>fun</code> argument. 
The function only needs one argument which is a vector of index for rows or columns depending whether it is 
a row annotation or column annotation. The other two optional arguments are the current slice index and total
number of slices. See **Examples** section for an example. If it is a normal R function, it will be constructed
into the <code><a href='AnnotationFunction-class.rd.html'>AnnotationFunction-class</a></code> object internally.</p>
<p>The <code><a href='SingleAnnotation-class.rd.html'>SingleAnnotation-class</a></code> is a simple wrapper on top of <code><a href='AnnotationFunction-class.rd.html'>AnnotationFunction-class</a></code> only with annotation 
name added.</p>
<p>The class also stored the "extended area" relative to the area for the annotation graphics. The extended areas
are those created by annotation names and axes.</p>
    
    <h2 class="hasAnchor" id="see-also"><a class="anchor" href="#see-also"></a>See also</h2>

    <div class='dont-index'><p>There are following built-in annotation functions that can be directly used to generate complex annotations: 
<code><a href='anno_simple.rd.html'>anno_simple</a></code>, <code><a href='anno_points.rd.html'>anno_points</a></code>, <code><a href='anno_lines.rd.html'>anno_lines</a></code>, <code><a href='anno_barplot.rd.html'>anno_barplot</a></code>, <code><a href='anno_histogram.rd.html'>anno_histogram</a></code>, <code><a href='anno_boxplot.rd.html'>anno_boxplot</a></code>, <code><a href='anno_density.rd.html'>anno_density</a></code>, <code><a href='anno_text.rd.html'>anno_text</a></code>,
<code><a href='anno_joyplot.rd.html'>anno_joyplot</a></code>, <code><a href='anno_horizon.rd.html'>anno_horizon</a></code>, <code><a href='anno_image.rd.html'>anno_image</a></code>, <code><a href='anno_block.rd.html'>anno_block</a></code>, <code><a href='anno_summary.rd.html'>anno_summary</a></code> and <code><a href='anno_mark.rd.html'>anno_mark</a></code>.</p></div>
    
    <h2 class="hasAnchor" id="value"><a class="anchor" href="#value"></a>Value</h2>

    <p>A <code><a href='SingleAnnotation-class.rd.html'>SingleAnnotation-class</a></code> object.</p>
    

    <h2 class="hasAnchor" id="examples"><a class="anchor" href="#examples"></a>Examples</h2>
    <pre class="examples"><div class='input'><span class='no'>ha</span> <span class='kw'>=</span> <span class='fu'><a href='SingleAnnotation.rd.html'>SingleAnnotation</a></span>(<span class='kw'>value</span> <span class='kw'>=</span> <span class='fl'>1</span>:<span class='fl'>10</span>)
<span class='fu'><a href='draw-dispatch.rd.html'>draw</a></span>(<span class='no'>ha</span>, <span class='kw'>test</span> <span class='kw'>=</span> <span class='st'>"single column annotation"</span>)</div><div class='img'><img src='SingleAnnotation-1.png' alt='' width='700' height='433' /></div><div class='input'>
<span class='no'>m</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/cbind.html'>cbind</a></span>(<span class='fl'>1</span>:<span class='fl'>10</span>, <span class='fl'>10</span>:<span class='fl'>1</span>)
<span class='fu'><a href='https://rdrr.io/r/base/colnames.html'>colnames</a></span>(<span class='no'>m</span>) <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/c.html'>c</a></span>(<span class='st'>"a"</span>, <span class='st'>"b"</span>)
<span class='no'>ha</span> <span class='kw'>=</span> <span class='fu'><a href='SingleAnnotation.rd.html'>SingleAnnotation</a></span>(<span class='kw'>value</span> <span class='kw'>=</span> <span class='no'>m</span>)
<span class='fu'><a href='draw-dispatch.rd.html'>draw</a></span>(<span class='no'>ha</span>, <span class='kw'>test</span> <span class='kw'>=</span> <span class='st'>"matrix as column annotation"</span>)</div><div class='img'><img src='SingleAnnotation-2.png' alt='' width='700' height='433' /></div><div class='input'>
<span class='no'>anno</span> <span class='kw'>=</span> <span class='fu'><a href='anno_barplot.rd.html'>anno_barplot</a></span>(<span class='fu'><a href='https://rdrr.io/r/base/matrix.html'>matrix</a></span>(<span class='kw'>nc</span> <span class='kw'>=</span> <span class='fl'>2</span>, <span class='fu'><a href='https://rdrr.io/r/base/c.html'>c</a></span>(<span class='fl'>1</span>:<span class='fl'>10</span>, <span class='fl'>10</span>:<span class='fl'>1</span>)))
<span class='no'>ha</span> <span class='kw'>=</span> <span class='fu'><a href='SingleAnnotation.rd.html'>SingleAnnotation</a></span>(<span class='kw'>fun</span> <span class='kw'>=</span> <span class='no'>anno</span>)
<span class='fu'><a href='draw-dispatch.rd.html'>draw</a></span>(<span class='no'>ha</span>, <span class='kw'>test</span> <span class='kw'>=</span> <span class='st'>"anno_barplot as input"</span>)</div><div class='img'><img src='SingleAnnotation-3.png' alt='' width='700' height='433' /></div><div class='input'>
<span class='no'>fun</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/eval.html'>local</a></span>({
    <span class='co'># because there variables outside the function for use, we put it a local environment</span>
    <span class='no'>value</span> <span class='kw'>=</span> <span class='fl'>1</span>:<span class='fl'>10</span>
    <span class='kw'>function</span>(<span class='no'>index</span>, <span class='no'>k</span> <span class='kw'>=</span> <span class='fl'>1</span>, <span class='no'>n</span> <span class='kw'>=</span> <span class='fl'>1</span>) {
        <span class='fu'>pushViewport</span>(<span class='fu'>viewport</span>(<span class='kw'>xscale</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/c.html'>c</a></span>(<span class='fl'>0.5</span>, <span class='fu'><a href='https://rdrr.io/r/base/length.html'>length</a></span>(<span class='no'>index</span>) + <span class='fl'>0.5</span>), <span class='kw'>yscale</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/range.html'>range</a></span>(<span class='no'>value</span>)))
        <span class='fu'>grid.points</span>(<span class='fu'><a href='https://rdrr.io/r/base/seq.html'>seq_along</a></span>(<span class='no'>index</span>), <span class='no'>value</span>[<span class='no'>index</span>])
        <span class='fu'>grid.rect</span>()
        <span class='kw'>if</span>(<span class='no'>k</span> <span class='kw'>==</span> <span class='fl'>1</span>) <span class='fu'>grid.yaxis</span>()
        <span class='fu'>popViewport</span>()
    }
})
<span class='no'>ha</span> <span class='kw'>=</span> <span class='fu'><a href='SingleAnnotation.rd.html'>SingleAnnotation</a></span>(<span class='kw'>fun</span> <span class='kw'>=</span> <span class='no'>fun</span>, <span class='kw'>height</span> <span class='kw'>=</span> <span class='fu'>unit</span>(<span class='fl'>4</span>, <span class='st'>"cm"</span>))
<span class='fu'><a href='draw-dispatch.rd.html'>draw</a></span>(<span class='no'>ha</span>, <span class='kw'>index</span> <span class='kw'>=</span> <span class='fl'>1</span>:<span class='fl'>10</span>, <span class='kw'>test</span> <span class='kw'>=</span> <span class='st'>"self-defined function"</span>)</div><div class='img'><img src='SingleAnnotation-4.png' alt='' width='700' height='433' /></div></pre>
  </div>
  <div class="col-md-3 hidden-xs hidden-sm" id="sidebar">
    <h2>Contents</h2>
    <ul class="nav nav-pills nav-stacked">
      <li><a href="#arguments">Arguments</a></li>
      
      <li><a href="#details">Details</a></li>

      <li><a href="#see-also">See also</a></li>

      <li><a href="#value">Value</a></li>
      
      <li><a href="#examples">Examples</a></li>
    </ul>

    <h2>Author</h2>
    <p>Zuguang Gu &lt;z.gu@dkfz.de&gt;</p>
  </div>
</div>


      <footer>
      <div class="copyright">
  <p>Developed by Zuguang Gu.</p>
</div>

<div class="pkgdown">
  <p>Site built with <a href="https://pkgdown.r-lib.org/">pkgdown</a> 1.4.1.</p>
</div>

      </footer>
   </div>

  


  </body>
</html>


