<!-- Generated by pkgdown: do not edit by hand -->
<!DOCTYPE html>
<html lang="en">
  <head>
  <meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Make a Single Legend — Legend • ComplexHeatmap</title>

<!-- jquery -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js" integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
<!-- Bootstrap -->

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.7/css/bootstrap.min.css" integrity="sha256-916EbMg70RQy9LHiGkXzG8hSg9EdNy97GazNG/aiY1w=" crossorigin="anonymous" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.7/js/bootstrap.min.js" integrity="sha256-U5ZEeKfGNOja007MMD3YBI0A3OSZOQbeG6z2f2Y0hu8=" crossorigin="anonymous"></script>

<!-- Font Awesome icons -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.7.1/css/all.min.css" integrity="sha256-nAmazAk6vS34Xqo0BSrTb+abbtFlgsFK7NKSi6o7Y78=" crossorigin="anonymous" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.7.1/css/v4-shims.min.css" integrity="sha256-6qHlizsOWFskGlwVOKuns+D1nB6ssZrHQrNj1wGplHc=" crossorigin="anonymous" />

<!-- clipboard.js -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/clipboard.js/2.0.4/clipboard.min.js" integrity="sha256-FiZwavyI2V6+EXO1U+xzLG3IKldpiTFf3153ea9zikQ=" crossorigin="anonymous"></script>

<!-- headroom.js -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/headroom/0.9.4/headroom.min.js" integrity="sha256-DJFC1kqIhelURkuza0AvYal5RxMtpzLjFhsnVIeuk+U=" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/headroom/0.9.4/jQuery.headroom.min.js" integrity="sha256-ZX/yNShbjqsohH1k95liqY9Gd8uOiE1S4vZc+9KQ1K4=" crossorigin="anonymous"></script>

<!-- pkgdown -->
<link href="../pkgdown.css" rel="stylesheet">
<script src="../pkgdown.js"></script>



<meta property="og:title" content="Make a Single Legend — Legend" />

<meta property="og:description" content="Make a Single Legend" />
<meta name="twitter:card" content="summary" />



<!-- mathjax -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.5/MathJax.js" integrity="sha256-nvJJv9wWKEm88qvoQl9ekL2J+k/RWIsaSScxxlsrv8k=" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.5/config/TeX-AMS-MML_HTMLorMML.js" integrity="sha256-84DKXVJXs0/F8OTMzX4UR909+jtl4G7SPypPavF+GfA=" crossorigin="anonymous"></script>

<!--[if lt IE 9]>
<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
<![endif]-->



  </head>

  <body>
    <div class="container template-reference-topic">
      <header>
      <div class="navbar navbar-default navbar-fixed-top" role="navigation">
  <div class="container">
    <div class="navbar-header">
      <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false">
        <span class="sr-only">Toggle navigation</span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
      </button>
      <span class="navbar-brand">
        <a class="navbar-link" href="../index.html">ComplexHeatmap</a>
        <span class="version label label-default" data-toggle="tooltip" data-placement="bottom" title="Released version">2.1.0</span>
      </span>
    </div>

    <div id="navbar" class="navbar-collapse collapse">
      <ul class="nav navbar-nav">
        <li>
  <a href="../index.html">
    <span class="fas fa fas fa-home fa-lg"></span>
     
  </a>
</li>
<li>
  <a href="../reference/index.html">Reference</a>
</li>
<li class="dropdown">
  <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">
    Articles
     
    <span class="caret"></span>
  </a>
  <ul class="dropdown-menu" role="menu">
    <li>
      <a href="../articles/complex_heatmap.html">UNKNOWN TITLE</a>
    </li>
    <li>
      <a href="../articles/most_probably_asked_questions.html">UNKNOWN TITLE</a>
    </li>
  </ul>
</li>
      </ul>
      
      <ul class="nav navbar-nav navbar-right">
        <li>
  <a href="https://github.com/jokergoo/ComplexHeatmap">
    <span class="fab fa fab fa-github fa-lg"></span>
     
  </a>
</li>
      </ul>
      
    </div><!--/.nav-collapse -->
  </div><!--/.container -->
</div><!--/.navbar -->

      

      </header>

<div class="row">
  <div class="col-md-9 contents">
    <div class="page-header">
    <h1>Make a Single Legend</h1>
    
    <div class="hidden name"><code>Legend.rd</code></div>
    </div>

    <div class="ref-description">
    
    <p>Make a Single Legend</p>
    
    </div>

    <pre class="usage"><span class='fu'><a href='Legend.rd.html'>Legend</a></span>(<span class='no'>at</span>, <span class='kw'>labels</span> <span class='kw'>=</span> <span class='no'>at</span>, <span class='no'>col_fun</span>, <span class='kw'>nrow</span> <span class='kw'>=</span> <span class='kw'>NULL</span>, <span class='kw'>ncol</span> <span class='kw'>=</span> <span class='fl'>1</span>, <span class='kw'>by_row</span> <span class='kw'>=</span> <span class='fl'>FALSE</span>,
    <span class='kw'>grid_height</span> <span class='kw'>=</span> <span class='fu'>unit</span>(<span class='fl'>4</span>, <span class='st'>"mm"</span>), <span class='kw'>grid_width</span> <span class='kw'>=</span> <span class='fu'>unit</span>(<span class='fl'>4</span>, <span class='st'>"mm"</span>), <span class='kw'>gap</span> <span class='kw'>=</span> <span class='fu'>unit</span>(<span class='fl'>2</span>, <span class='st'>"mm"</span>),
    <span class='kw'>labels_gp</span> <span class='kw'>=</span> <span class='fu'>gpar</span>(<span class='kw'>fontsize</span> <span class='kw'>=</span> <span class='fl'>10</span>), <span class='kw'>labels_rot</span> <span class='kw'>=</span> <span class='fl'>0</span>,
    <span class='kw'>border</span> <span class='kw'>=</span> <span class='kw'>NULL</span>, <span class='kw'>background</span> <span class='kw'>=</span> <span class='st'>"#EEEEEE"</span>,
    <span class='kw'>type</span> <span class='kw'>=</span> <span class='st'>"grid"</span>, <span class='kw'>legend_gp</span> <span class='kw'>=</span> <span class='fu'>gpar</span>(),
    <span class='kw'>pch</span> <span class='kw'>=</span> <span class='fl'>16</span>, <span class='kw'>size</span> <span class='kw'>=</span> <span class='fu'>unit</span>(<span class='fl'>2</span>, <span class='st'>"mm"</span>),
    <span class='kw'>legend_height</span> <span class='kw'>=</span> <span class='kw'>NULL</span>, <span class='kw'>legend_width</span> <span class='kw'>=</span> <span class='kw'>NULL</span>,
    <span class='kw'>direction</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/c.html'>c</a></span>(<span class='st'>"vertical"</span>, <span class='st'>"horizontal"</span>),
    <span class='kw'>title</span> <span class='kw'>=</span> <span class='st'>""</span>, <span class='kw'>title_gp</span> <span class='kw'>=</span> <span class='fu'>gpar</span>(<span class='kw'>fontsize</span> <span class='kw'>=</span> <span class='fl'>10</span>, <span class='kw'>fontface</span> <span class='kw'>=</span> <span class='st'>"bold"</span>),
    <span class='kw'>title_position</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/c.html'>c</a></span>(<span class='st'>"topleft"</span>, <span class='st'>"topcenter"</span>, <span class='st'>"leftcenter"</span>, <span class='st'>"lefttop"</span>, <span class='st'>"leftcenter-rot"</span>, <span class='st'>"lefttop-rot"</span>),
    <span class='kw'>title_gap</span> <span class='kw'>=</span> <span class='fu'>unit</span>(<span class='fl'>1.5</span>, <span class='st'>"mm"</span>))</pre>
    
    <h2 class="hasAnchor" id="arguments"><a class="anchor" href="#arguments"></a>Arguments</h2>
    <table class="ref-arguments">
    <colgroup><col class="name" /><col class="desc" /></colgroup>
    <tr>
      <th>at</th>
      <td><p>Breaks of the legend. The values can be either numeric or character. If it is not specified, the values of <code>labels</code> are taken as labels.</p></td>
    </tr>
    <tr>
      <th>labels</th>
      <td><p>Labels corresponding to <code>at</code>. If it is not specified, the values of <code>at</code> are taken as labels.</p></td>
    </tr>
    <tr>
      <th>col_fun</th>
      <td><p>A color mapping function which is used to make a continuous legend. Use <code><a href='https://rdrr.io/pkg/circlize/man/colorRamp2.html'>colorRamp2</a></code> to generate the color mapping function. If <code>at</code> is missing, the breaks recorded in the color mapping function are used for <code>at</code>.</p></td>
    </tr>
    <tr>
      <th>nrow</th>
      <td><p>For legend which is represented as grids, <code>nrow</code> controls number of rows of the grids if the grids are arranged into multiple rows.</p></td>
    </tr>
    <tr>
      <th>ncol</th>
      <td><p>Similar as <code>nrow</code>, <code>ncol</code> controls number of columns of the grids if the grids are arranged into multiple columns. Note at a same time only one of <code>nrow</code> and <code>ncol</code> can be specified.</p></td>
    </tr>
    <tr>
      <th>by_row</th>
      <td><p>Are the legend grids arranged by rows or by columns?</p></td>
    </tr>
    <tr>
      <th>grid_height</th>
      <td><p>The height of legend grid. It can also control the height of the continuous legend if it is horizontal.</p></td>
    </tr>
    <tr>
      <th>grid_width</th>
      <td><p>The width of legend grid. It can also control the width of the continuous legend if it is vertical.</p></td>
    </tr>
    <tr>
      <th>gap</th>
      <td><p>If legend grids are put into multiple rows or columns, this controls the gap between neighbouring rows or columns, measured as a <code><a href='https://rdrr.io/r/grid/unit.html'>unit</a></code> object.</p></td>
    </tr>
    <tr>
      <th>labels_gp</th>
      <td><p>Graphic parameters for labels.</p></td>
    </tr>
    <tr>
      <th>labels_rot</th>
      <td><p>Text rotation for labels. It should only be used for horizontal continuous legend.</p></td>
    </tr>
    <tr>
      <th>border</th>
      <td><p>Color of legend grid borders. It also works for the ticks in the continuous legend.</p></td>
    </tr>
    <tr>
      <th>background</th>
      <td><p>Background colors for the grids. It is used when points and lines are the legend graphics.</p></td>
    </tr>
    <tr>
      <th>type</th>
      <td><p>Type of legends. The value can be one of <code>grid</code>, <code>points</code>, <code>lines</code> and <code>boxplot</code>.</p></td>
    </tr>
    <tr>
      <th>legend_gp</th>
      <td><p>Graphic parameters for the legend grids. You should control the filled color of the legend grids by <code>gpar(fill = ...)</code>.</p></td>
    </tr>
    <tr>
      <th>pch</th>
      <td><p>Type of points if points are used as legend. Note you can use single-letter as pch, e.g. <code>pch = 'A'</code>. There are three additional integers that are valid for <code>pch</code>: 26 and 27 for single diagonal lines and 28 for double diagonal lines.</p></td>
    </tr>
    <tr>
      <th>size</th>
      <td><p>Size of points.</p></td>
    </tr>
    <tr>
      <th>legend_height</th>
      <td><p>Height of the whole legend body. It is only used for vertical continous legend.</p></td>
    </tr>
    <tr>
      <th>legend_width</th>
      <td><p>Width of the whole legend body. It is only used for horizontal continous legend.</p></td>
    </tr>
    <tr>
      <th>direction</th>
      <td><p>Direction of the legend, vertical or horizontal?</p></td>
    </tr>
    <tr>
      <th>title</th>
      <td><p>Title of the legend.</p></td>
    </tr>
    <tr>
      <th>title_gp</th>
      <td><p>Graphic parameters of the title.</p></td>
    </tr>
    <tr>
      <th>title_position</th>
      <td><p>Position of title relative to the legend. <code>topleft</code>, <code>topcenter</code>, <code>leftcenter-rot</code> and <code>lefttop-rot</code> are only for vertical legend and <code>leftcenter</code>, <code>lefttop</code> are only for  horizontal legend.</p></td>
    </tr>
    <tr>
      <th>title_gap</th>
      <td><p>Gap between title and the legend body.</p></td>
    </tr>
    </table>
    
    <h2 class="hasAnchor" id="details"><a class="anchor" href="#details"></a>Details</h2>

    <p>Most of the argument can also be set in <code>heatmap_legend_param</code> argument in <code><a href='Heatmap.rd.html'>Heatmap</a></code> or <code>annotation_legend_param</code>
argument in <code><a href='HeatmapAnnotation.rd.html'>HeatmapAnnotation</a></code> to configure legend styles for heatmap and annotations.</p>
    
    <h2 class="hasAnchor" id="see-also"><a class="anchor" href="#see-also"></a>See also</h2>

    <div class='dont-index'><p><code><a href='packLegend.rd.html'>packLegend</a></code> packs multiple legends into one <code><a href='Legends-class.rd.html'>Legends-class</a></code> object.</p>
<p>See examples of configuring legends: <a href='https://jokergoo.github.io/ComplexHeatmap-reference/book/legends.html'>https://jokergoo.github.io/ComplexHeatmap-reference/book/legends.html</a></p></div>
    
    <h2 class="hasAnchor" id="value"><a class="anchor" href="#value"></a>Value</h2>

    <p>A <code><a href='Legends-class.rd.html'>Legends-class</a></code> object.</p>
    

    <h2 class="hasAnchor" id="examples"><a class="anchor" href="#examples"></a>Examples</h2>
    <pre class="examples"><div class='input'><span class='no'>lgd</span> <span class='kw'>=</span> <span class='fu'><a href='Legend.rd.html'>Legend</a></span>(<span class='kw'>labels</span> <span class='kw'>=</span> <span class='no'>month.name</span>[<span class='fl'>1</span>:<span class='fl'>6</span>], <span class='kw'>title</span> <span class='kw'>=</span> <span class='st'>"foo"</span>, <span class='kw'>legend_gp</span> <span class='kw'>=</span> <span class='fu'>gpar</span>(<span class='kw'>fill</span> <span class='kw'>=</span> <span class='fl'>1</span>:<span class='fl'>6</span>))
<span class='fu'><a href='draw-dispatch.rd.html'>draw</a></span>(<span class='no'>lgd</span>, <span class='kw'>test</span> <span class='kw'>=</span> <span class='st'>"add labels and title"</span>)</div><div class='img'><img src='Legend-1.png' alt='' width='700' height='433' /></div><div class='input'>
<span class='fu'><a href='https://rdrr.io/r/base/library.html'>require</a></span>(<span class='no'>circlize</span>)
<span class='no'>col_fun</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/pkg/circlize/man/colorRamp2.html'>colorRamp2</a></span>(<span class='fu'><a href='https://rdrr.io/r/base/c.html'>c</a></span>(<span class='fl'>0</span>, <span class='fl'>0.5</span>, <span class='fl'>1</span>), <span class='fu'><a href='https://rdrr.io/r/base/c.html'>c</a></span>(<span class='st'>"blue"</span>, <span class='st'>"white"</span>, <span class='st'>"red"</span>))
<span class='no'>lgd</span> <span class='kw'>=</span> <span class='fu'><a href='Legend.rd.html'>Legend</a></span>(<span class='kw'>col_fun</span> <span class='kw'>=</span> <span class='no'>col_fun</span>, <span class='kw'>title</span> <span class='kw'>=</span> <span class='st'>"foo"</span>)
<span class='fu'><a href='draw-dispatch.rd.html'>draw</a></span>(<span class='no'>lgd</span>, <span class='kw'>test</span> <span class='kw'>=</span> <span class='st'>"only col_fun"</span>)</div><div class='img'><img src='Legend-2.png' alt='' width='700' height='433' /></div><div class='input'>
<span class='no'>col_fun</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/pkg/circlize/man/colorRamp2.html'>colorRamp2</a></span>(<span class='fu'><a href='https://rdrr.io/r/base/c.html'>c</a></span>(<span class='fl'>0</span>, <span class='fl'>0.5</span>, <span class='fl'>1</span>), <span class='fu'><a href='https://rdrr.io/r/base/c.html'>c</a></span>(<span class='st'>"blue"</span>, <span class='st'>"white"</span>, <span class='st'>"red"</span>))
<span class='no'>lgd</span> <span class='kw'>=</span> <span class='fu'><a href='Legend.rd.html'>Legend</a></span>(<span class='kw'>col_fun</span> <span class='kw'>=</span> <span class='no'>col_fun</span>, <span class='kw'>title</span> <span class='kw'>=</span> <span class='st'>"foo"</span>, <span class='kw'>at</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/c.html'>c</a></span>(<span class='fl'>0</span>, <span class='fl'>0.1</span>, <span class='fl'>0.15</span>, <span class='fl'>0.5</span>, <span class='fl'>0.9</span>, <span class='fl'>0.95</span>, <span class='fl'>1</span>))
<span class='fu'><a href='draw-dispatch.rd.html'>draw</a></span>(<span class='no'>lgd</span>, <span class='kw'>test</span> <span class='kw'>=</span> <span class='st'>"unequal interval breaks"</span>)</div><div class='img'><img src='Legend-3.png' alt='' width='700' height='433' /></div></pre>
  </div>
  <div class="col-md-3 hidden-xs hidden-sm" id="sidebar">
    <h2>Contents</h2>
    <ul class="nav nav-pills nav-stacked">
      <li><a href="#arguments">Arguments</a></li>
      
      <li><a href="#details">Details</a></li>

      <li><a href="#see-also">See also</a></li>

      <li><a href="#value">Value</a></li>
      
      <li><a href="#examples">Examples</a></li>
    </ul>

  </div>
</div>


      <footer>
      <div class="copyright">
  <p>Developed by Zuguang Gu.</p>
</div>

<div class="pkgdown">
  <p>Site built with <a href="https://pkgdown.r-lib.org/">pkgdown</a> 1.4.1.</p>
</div>

      </footer>
   </div>

  


  </body>
</html>


