<!-- Generated by pkgdown: do not edit by hand -->
<!DOCTYPE html>
<html lang="en">
  <head>
  <meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Constructor of AnnotationFunction Class — AnnotationFunction • ComplexHeatmap</title>


<!-- jquery -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js" integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
<!-- Bootstrap -->

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.7/css/bootstrap.min.css" integrity="sha256-916EbMg70RQy9LHiGkXzG8hSg9EdNy97GazNG/aiY1w=" crossorigin="anonymous" />

<script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.7/js/bootstrap.min.js" integrity="sha256-U5ZEeKfGNOja007MMD3YBI0A3OSZOQbeG6z2f2Y0hu8=" crossorigin="anonymous"></script>

<!-- Font Awesome icons -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.7.1/css/all.min.css" integrity="sha256-nAmazAk6vS34Xqo0BSrTb+abbtFlgsFK7NKSi6o7Y78=" crossorigin="anonymous" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.7.1/css/v4-shims.min.css" integrity="sha256-6qHlizsOWFskGlwVOKuns+D1nB6ssZrHQrNj1wGplHc=" crossorigin="anonymous" />

<!-- clipboard.js -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/clipboard.js/2.0.4/clipboard.min.js" integrity="sha256-FiZwavyI2V6+EXO1U+xzLG3IKldpiTFf3153ea9zikQ=" crossorigin="anonymous"></script>

<!-- headroom.js -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/headroom/0.9.4/headroom.min.js" integrity="sha256-DJFC1kqIhelURkuza0AvYal5RxMtpzLjFhsnVIeuk+U=" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/headroom/0.9.4/jQuery.headroom.min.js" integrity="sha256-ZX/yNShbjqsohH1k95liqY9Gd8uOiE1S4vZc+9KQ1K4=" crossorigin="anonymous"></script>

<!-- pkgdown -->
<link href="../pkgdown.css" rel="stylesheet">
<script src="../pkgdown.js"></script>




<meta property="og:title" content="Constructor of AnnotationFunction Class — AnnotationFunction" />
<meta property="og:description" content="Constructor of AnnotationFunction Class" />
<meta name="twitter:card" content="summary" />




<!-- mathjax -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.5/MathJax.js" integrity="sha256-nvJJv9wWKEm88qvoQl9ekL2J+k/RWIsaSScxxlsrv8k=" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.5/config/TeX-AMS-MML_HTMLorMML.js" integrity="sha256-84DKXVJXs0/F8OTMzX4UR909+jtl4G7SPypPavF+GfA=" crossorigin="anonymous"></script>

<!--[if lt IE 9]>
<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
<![endif]-->



  </head>

  <body>
    <div class="container template-reference-topic">
      <header>
      <div class="navbar navbar-default navbar-fixed-top" role="navigation">
  <div class="container">
    <div class="navbar-header">
      <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false">
        <span class="sr-only">Toggle navigation</span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
      </button>
      <span class="navbar-brand">
        <a class="navbar-link" href="../index.html">ComplexHeatmap</a>
        <span class="version label label-default" data-toggle="tooltip" data-placement="bottom" title="Released version">2.1.1</span>
      </span>
    </div>

    <div id="navbar" class="navbar-collapse collapse">
      <ul class="nav navbar-nav">
        <li>
  <a href="../index.html">
    <span class="fas fa fas fa-home fa-lg"></span>
     
  </a>
</li>
<li>
  <a href="../reference/index.html">Reference</a>
</li>
<li class="dropdown">
  <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">
    Articles
     
    <span class="caret"></span>
  </a>
  <ul class="dropdown-menu" role="menu">
    <li>
      <a href="../articles/complex_heatmap.html">UNKNOWN TITLE</a>
    </li>
    <li>
      <a href="../articles/most_probably_asked_questions.html">UNKNOWN TITLE</a>
    </li>
  </ul>
</li>
      </ul>
      <ul class="nav navbar-nav navbar-right">
        <li>
  <a href="https://github.com/jokergoo/ComplexHeatmap">
    <span class="fab fa fab fa-github fa-lg"></span>
     
  </a>
</li>
      </ul>
      
    </div><!--/.nav-collapse -->
  </div><!--/.container -->
</div><!--/.navbar -->

      

      </header>

<div class="row">
  <div class="col-md-9 contents">
    <div class="page-header">
    <h1>Constructor of AnnotationFunction Class</h1>
    
    <div class="hidden name"><code>AnnotationFunction.rd</code></div>
    </div>

    <div class="ref-description">
    <p>Constructor of AnnotationFunction Class</p>
    </div>

    <pre class="usage"><span class='fu'><a href='AnnotationFunction.rd.html'>AnnotationFunction</a></span>(<span class='no'>fun</span>, <span class='kw'>fun_name</span> <span class='kw'>=</span> <span class='st'>""</span>, <span class='kw'>which</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/c.html'>c</a></span>(<span class='st'>"column"</span>, <span class='st'>"row"</span>),
    <span class='kw'>var_import</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/list.html'>list</a></span>(), <span class='kw'>n</span> <span class='kw'>=</span> <span class='fl'>NA</span>, <span class='kw'>data_scale</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/c.html'>c</a></span>(<span class='fl'>0</span>, <span class='fl'>1</span>), <span class='kw'>subset_rule</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/list.html'>list</a></span>(),
    <span class='kw'>subsetable</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/length.html'>length</a></span>(<span class='no'>subset_rule</span>) <span class='kw'>&gt;</span> <span class='fl'>0</span>, <span class='kw'>show_name</span> <span class='kw'>=</span> <span class='fl'>TRUE</span>, <span class='kw'>width</span> <span class='kw'>=</span> <span class='kw'>NULL</span>, <span class='kw'>height</span> <span class='kw'>=</span> <span class='kw'>NULL</span>)</pre>

    <h2 class="hasAnchor" id="arguments"><a class="anchor" href="#arguments"></a>Arguments</h2>
    <table class="ref-arguments">
    <colgroup><col class="name" /><col class="desc" /></colgroup>
    <tr>
      <th>fun</th>
      <td><p>A function which defines how to draw the annotation. See **Details** section.</p></td>
    </tr>
    <tr>
      <th>fun_name</th>
      <td><p>The name of the function. It is only used for printing the object.</p></td>
    </tr>
    <tr>
      <th>which</th>
      <td><p>Whether it is drawn as a column annotation or a row annotation?</p></td>
    </tr>
    <tr>
      <th>var_import</th>
      <td><p>The names of the variables or the variable themselves that the annotation function depends on. See **Details** section.</p></td>
    </tr>
    <tr>
      <th>n</th>
      <td><p>Number of observations in the annotation. It is not mandatory, but it is better to provide this information so that the higher order <code><a href='HeatmapAnnotation.rd.html'>HeatmapAnnotation</a></code> knows it and it can perform check on the consistency of annotations and heatmaps.</p></td>
    </tr>
    <tr>
      <th>data_scale</th>
      <td><p>The data scale on the data axis (y-axis for column annotation and x-axis for row annotation). It is only used when <code><a href='decorate_annotation.rd.html'>decorate_annotation</a></code> is used with "native" unit coordinates.</p></td>
    </tr>
    <tr>
      <th>subset_rule</th>
      <td><p>The rule of subsetting variables in <code>var_import</code>. It should be set when users want the final object to be subsetable. See **Details** section.</p></td>
    </tr>
    <tr>
      <th>subsetable</th>
      <td><p>Whether the object is subsetable?</p></td>
    </tr>
    <tr>
      <th>show_name</th>
      <td><p>It is used to turn off the drawing of annotation names in <code><a href='HeatmapAnnotation.rd.html'>HeatmapAnnotation</a></code>. Annotations always have names associated and normally they will be drawn beside the annotation graphics to tell what the annotation is about. e.g. the annotation names put beside the points annotation graphics. However, for some of the annotations, the names are not necessarily to be drawn, such as text annotations drawn by <code><a href='anno_text.rd.html'>anno_text</a></code> or an empty annotation drawn by <code><a href='anno_empty.rd.html'>anno_empty</a></code>. In this case, when <code>show_names</code> is set to <code>FALSE</code>, there will be no annotation names drawn for the annotation.</p></td>
    </tr>
    <tr>
      <th>width</th>
      <td><p>The width of the plotting region (the viewport) that the annotation is drawn. If it is a row annotation, the width must be an absolute unit. Since the <code>AnnotationFunction</code> object is always contained by the <code><a href='SingleAnnotation-class.rd.html'>SingleAnnotation-class</a></code>object, you can only set the width of row annotations or height of column annotations, while e.g. the height of the row annotation is always <code>unit(1, "npc")</code> which means it always fully filled in the parent <code>SingleAnnotation</code> and only in <code><a href='SingleAnnotation.rd.html'>SingleAnnotation</a></code> or even <code><a href='HeatmapAnnotation.rd.html'>HeatmapAnnotation</a></code> can adjust the height of the row annotations.</p></td>
    </tr>
    <tr>
      <th>height</th>
      <td><p>The height of the plotting region (the viewport) that the annotation is drawn. If it is a column annotation, the width must be an absolute unit.</p></td>
    </tr>
    </table>

    <h2 class="hasAnchor" id="details"><a class="anchor" href="#details"></a>Details</h2>

    <p>In the package, we have implemted quite a lot annotation functions by <code><a href='AnnotationFunction.rd.html'>AnnotationFunction</a></code> constructor:
<code><a href='anno_empty.rd.html'>anno_empty</a></code>, <code><a href='anno_image.rd.html'>anno_image</a></code>, <code><a href='anno_points.rd.html'>anno_points</a></code>, <code><a href='anno_lines.rd.html'>anno_lines</a></code>, <code><a href='anno_barplot.rd.html'>anno_barplot</a></code>, <code><a href='anno_boxplot.rd.html'>anno_boxplot</a></code>, <code><a href='anno_histogram.rd.html'>anno_histogram</a></code>,
<code><a href='anno_density.rd.html'>anno_density</a></code>, <code><a href='anno_joyplot.rd.html'>anno_joyplot</a></code>, <code><a href='anno_horizon.rd.html'>anno_horizon</a></code>, <code><a href='anno_text.rd.html'>anno_text</a></code> and <code><a href='anno_mark.rd.html'>anno_mark</a></code>. These built-in annotation functions
support as both row annotations and column annotations and they are are all subsettable.</p>
<p>The build-in annotation functions are already enough for most of the analysis, nevertheless, if users
want to know more about how to construct the AnnotationFunction class manually, they can refer to
<a href='https://jokergoo.github.io/ComplexHeatmap-reference/book/heatmap-annotations.html#implement-new-annotation-functions.'>https://jokergoo.github.io/ComplexHeatmap-reference/book/heatmap-annotations.html#implement-new-annotation-functions.</a></p>
    <h2 class="hasAnchor" id="value"><a class="anchor" href="#value"></a>Value</h2>

    <p>A <code><a href='AnnotationFunction-class.rd.html'>AnnotationFunction-class</a></code> object which can be used in <code><a href='HeatmapAnnotation.rd.html'>HeatmapAnnotation</a></code>.</p>

    <h2 class="hasAnchor" id="examples"><a class="anchor" href="#examples"></a>Examples</h2>
    <pre class="examples"><div class='input'><span class='no'>x</span> <span class='kw'>=</span> <span class='fl'>1</span>:<span class='fl'>10</span>
<span class='no'>anno1</span> <span class='kw'>=</span> <span class='fu'><a href='AnnotationFunction.rd.html'>AnnotationFunction</a></span>(
    <span class='kw'>fun</span> <span class='kw'>=</span> <span class='kw'>function</span>(<span class='no'>index</span>, <span class='no'>k</span>, <span class='no'>n</span>) {
        <span class='no'>n</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/length.html'>length</a></span>(<span class='no'>index</span>)
        <span class='fu'>pushViewport</span>(<span class='fu'>viewport</span>(<span class='kw'>xscale</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/c.html'>c</a></span>(<span class='fl'>0.5</span>, <span class='no'>n</span> + <span class='fl'>0.5</span>), <span class='kw'>yscale</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/c.html'>c</a></span>(<span class='fl'>0</span>, <span class='fl'>10</span>)))
        <span class='fu'>grid.rect</span>()
        <span class='fu'>grid.points</span>(<span class='fl'>1</span>:<span class='no'>n</span>, <span class='no'>x</span>[<span class='no'>index</span>], <span class='kw'>default.units</span> <span class='kw'>=</span> <span class='st'>"native"</span>)
        <span class='kw'>if</span>(<span class='no'>k</span> <span class='kw'>==</span> <span class='fl'>1</span>) <span class='fu'>grid.yaxis</span>()
        <span class='fu'>popViewport</span>()
    },
    <span class='kw'>var_import</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/list.html'>list</a></span>(<span class='kw'>x</span> <span class='kw'>=</span> <span class='no'>x</span>),
    <span class='kw'>n</span> <span class='kw'>=</span> <span class='fl'>10</span>,
    <span class='kw'>subsetable</span> <span class='kw'>=</span> <span class='fl'>TRUE</span>,
    <span class='kw'>height</span> <span class='kw'>=</span> <span class='fu'>unit</span>(<span class='fl'>2</span>, <span class='st'>"cm"</span>)
)
<span class='no'>m</span> <span class='kw'>=</span> <span class='fu'><a href='https://rdrr.io/r/base/cbind.html'>rbind</a></span>(<span class='fl'>1</span>:<span class='fl'>10</span>, <span class='fl'>11</span>:<span class='fl'>20</span>)
<span class='fu'><a href='Heatmap.rd.html'>Heatmap</a></span>(<span class='no'>m</span>, <span class='kw'>top_annotation</span> <span class='kw'>=</span> <span class='fu'><a href='HeatmapAnnotation.rd.html'>HeatmapAnnotation</a></span>(<span class='kw'>foo</span> <span class='kw'>=</span> <span class='no'>anno1</span>))</div><div class='img'><img src='AnnotationFunction-1.png' alt='' width='700' height='433' /></div><div class='input'><span class='fu'><a href='Heatmap.rd.html'>Heatmap</a></span>(<span class='no'>m</span>, <span class='kw'>top_annotation</span> <span class='kw'>=</span> <span class='fu'><a href='HeatmapAnnotation.rd.html'>HeatmapAnnotation</a></span>(<span class='kw'>foo</span> <span class='kw'>=</span> <span class='no'>anno1</span>), <span class='kw'>column_km</span> <span class='kw'>=</span> <span class='fl'>2</span>)</div><div class='img'><img src='AnnotationFunction-2.png' alt='' width='700' height='433' /></div></pre>
  </div>
  <div class="col-md-3 hidden-xs hidden-sm" id="sidebar">
    <h2>Contents</h2>
    <ul class="nav nav-pills nav-stacked">
      <li><a href="#arguments">Arguments</a></li>
      <li><a href="#details">Details</a></li>
      <li><a href="#value">Value</a></li>
      <li><a href="#examples">Examples</a></li>
    </ul>

  </div>
</div>


      <footer>
      <div class="copyright">
  <p>Developed by Zuguang Gu.</p>
</div>

<div class="pkgdown">
  <p>Site built with <a href="https://pkgdown.r-lib.org/">pkgdown</a> 1.4.1.</p>
</div>

      </footer>
   </div>

  


  </body>
</html>


