% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupHeatMap.R
\name{groupHeatMap}
\alias{groupHeatMap}
\title{Make heatmap}
\usage{
groupHeatMap(
  dataFrame,
  groupData,
  groupName,
  titleAlign = "left",
  newNamesCol = NULL,
  colNumber = 2,
  ylabel = "Protein",
  xlabel = "Fraction",
  legendLabel = "Relative Protein Abundance",
  legendPosition = "right",
  grid = TRUE,
  labelled = "labeled",
  unlabelled = "unlabeled",
  orderColumn = NULL
)
}
\arguments{
\item{dataFrame}{data frame, contains columns:
`Protein Group Accessions` character
`Protein Descriptions` character
 Fraction integer
 isLabel character ('TRUE'/'FALSE' values)
 `Precursor Area` double
 scenario character}

\item{groupData}{data frame, mandatory column: 
`Protein Group Accessions` character - this column is used for filtering
           optional columns: any other column of type character that should
            be used for renaming}

\item{groupName}{character, name that should be used for the group specified
in groupData}

\item{titleAlign}{character, one of the 'left', 'center'/'centre', 'right', 
specifies alignment of the title in plot}

\item{newNamesCol}{character, if groupData contains column for re-naming and 
you want to use it, specify the column name in here}

\item{colNumber}{numeric, values of 1 or 2, specifies whether facets will be 
shown side-by-side or above each other}

\item{ylabel}{character}

\item{xlabel}{character}

\item{legendLabel}{character}

\item{legendPosition}{character, one of "right" or "bottom"}

\item{grid}{logical, specifies presence/absence of gridline in the plot}

\item{labelled}{character, label to be used for isLabel == TRUE}

\item{unlabelled}{character, label to be used for isLabel == FALSE}

\item{orderColumn}{character, if groupData contains column for re-ordering
and you want to use it, specify the column name in here}
}
\value{
plot
}
\description{
This function creates a heatmap for a subset of proteins in dataFrame
specified in groupData, heatmap is divided into facets according to isLabel
}
\examples{

##Use example normalised proteins file
inputFile <- system.file("extData", "dataNormProts.txt", package = "ComPrAn")
#read file in and change structure of table to required format
forAnalysis <- protImportForAnalysis(inputFile)
##example plot:
groupDfn <- system.file("extData", "exampleGroup.txt", package = "ComPrAn")
groupName <- 'group1'
groupData <- data.table::fread(groupDfn)
groupHeatMap(forAnalysis[forAnalysis$scenario == "B",], groupData, groupName)

}
