% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allPeptidesPlot.R
\name{allPeptidesPlot}
\alias{allPeptidesPlot}
\title{Create scatter plot}
\usage{
allPeptidesPlot(
  .listDF,
  protein,
  max_frac,
  meanLine = FALSE,
  repPepLine = FALSE,
  separateLabStates = FALSE,
  grid = TRUE,
  titleLabel = "all",
  titleAlign = "left",
  ylabel = "Precursor Area",
  xlabel = "Fraction",
  legendLabel = "Condition",
  labelled = "Labeled",
  unlabelled = "Unlabeled",
  controlSample = "",
  textSize = 12,
  axisTextSize = 8
)
}
\arguments{
\item{.listDF}{list, list containing data frames of peptides for each
protein indexed by `Protein Group Accessions`}

\item{protein}{character, `Protein Group Accession` to show in the plot}

\item{max_frac}{numeric, total number of fractions}

\item{meanLine}{logical, specifies whether to plot a mean line}

\item{repPepLine}{logical, specifies whether to plot a representative 
peptide line}

\item{separateLabStates}{logical, specifies whether label states will be 
separated into facets}

\item{grid}{logical, specifies presence/absence of gridline in the plot}

\item{titleLabel}{character, what to call the plot}

\item{titleAlign}{character, one of the 'left', 'center'/'centre', 'right', 
specifies alignment of the title in plot}

\item{ylabel}{character}

\item{xlabel}{character}

\item{legendLabel}{character}

\item{labelled}{character, label to be used for isLabel == TRUE}

\item{unlabelled}{character, label to be used for isLabel == FALSE}

\item{controlSample}{character, either labelled or unlabelled, this setting
will adjust coloring based on which sample is a control}

\item{textSize}{numeric, size of text in the plot}

\item{axisTextSize}{numeric, size of axis labels in the plot}
}
\value{
plot
}
\description{
This function creates a plot of all peptides that belong to a single protein
}
\examples{
##Use example peptide data set, read in and clean data
inputFile <- system.file("extData", "data.txt", package = "ComPrAn")
peptides <- peptideImport(inputFile)
peptides <- cleanData(peptides, fCol = "Search ID")
## separate chemical modifications and labelling into separate columns
peptides <- splitModLab(peptides) 
## remove unneccessary columns, simplify rows
peptides <- simplifyProteins(peptides) 
## Pick representative peptide for each protein for both scenarios
peptide_index <- pickPeptide(peptides)

##create a plot showing all peptides of selected protein
protein <- "P52815"
max_frac <- 23
#default plot
allPeptidesPlot(peptide_index,protein, max_frac = max_frac)
#other plot version
allPeptidesPlot(peptide_index,protein, max_frac = max_frac,
repPepLine = TRUE, grid = FALSE, titleAlign = "center")
#other plot version
allPeptidesPlot(peptide_index,protein, max_frac = max_frac,
repPepLine = TRUE, meanLine = TRUE, separateLabStates =TRUE,
titleLabel = "GN")
}
