% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoSIA-getGExMetrics-method.R
\name{getGExMetrics,CoSIAn-method}
\alias{getGExMetrics,CoSIAn-method}
\title{getGExMetrics Method}
\usage{
\S4method{getGExMetrics}{CoSIAn}(object)
}
\arguments{
\item{object}{CoSIAn object with all user accessible slots filled with
converted_id slot filled}
}
\value{
CoSIAn Object with metric slot filled
}
\description{
getGExMetrics Method
}
\examples{
Kidney_Genes <- CoSIAn(
    gene_set = c("ENSG00000008710", "ENSG00000118762", "ENSG00000152217"),
    i_species = "h_sapiens", input_id = "Ensembl_id", o_species = c(
        "h_sapiens", "r_norvegicus"
    ), output_ids = c("Ensembl_id", "Symbol"),
    mapping_tool = "annotationDBI", ortholog_database = "HomoloGene",
    map_tissues = "heart", map_species = c("r_norvegicus"),
    metric_type = "DS_Gene"
)
Kidney_gene_conversion <- CoSIA::getConversion(Kidney_Genes)
Kidney_gene_metric <- getGExMetrics(Kidney_gene_conversion)
}
\references{
Kohl M (2022). MKdescr: Descriptive Statistics. R package version 
0.8, https://github.com/stamats/MKdescr.

Zhang JD, Hatje K, Sturm G, Broger C, Ebeling M, Burtin M, Terzi 
F, Pomposiello SI, Badi L (2017). “Detect tissue heterogeneity in gene 
expression data with BioQC.” BMC Genomics, 18(1), 277. 
http://accio.github.io/BioQC/.
}
