% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All-classes.R, R/initialize-methods.R,
%   R/permutation-methods.R, R/plot-methods.R, R/show-methods.R
\docType{class}
\name{PermutationResults-class}
\alias{PermutationResults-class}
\alias{.PermutationResults}
\alias{getData,PermutationResults-method}
\alias{c,PermutationResults-method}
\alias{pvalue}
\alias{pvalue,PermutationResults-method}
\alias{conf.int}
\alias{conf.int,PermutationResults-method}
\alias{initialize,PermutationResults-method}
\alias{permute}
\alias{permute,matrix-method}
\alias{permute}
\alias{permute,matrix-method}
\alias{plot,PermutationResults,missing-method}
\alias{show,PermutationResults-method}
\title{Permutation test}
\usage{
\S4method{getData}{PermutationResults}(x, n = NULL)

\S4method{c}{PermutationResults}(x, ..., recursive = FALSE)

pvalue(x, ...)

\S4method{pvalue}{PermutationResults}(x, ...)

conf.int(x, ...)

\S4method{conf.int}{PermutationResults}(x, conf.level = 0.99, ...)

\S4method{initialize}{PermutationResults}(.Object, ..., scores.real, scores.vec)

permute(mat, ...)

\S4method{permute}{matrix}(mat, classes, projmethod = "pcp", iter = 100,
  user.permutations = NULL, seed = 3, df = NULL, verbose = TRUE, ...)

\S4method{plot}{PermutationResults,missing}(x, y, comparison = "all", ...)

\S4method{show}{PermutationResults}(object)
}
\arguments{
\item{x}{matrix for the function permute, otherwise it is a
PermutationResults object}

\item{n}{data to extract from ClassifiedPoints (NULL gives all)}

\item{...}{arguments to pass on}

\item{recursive}{dont use (belongs to default generic of combine 'c()')}

\item{conf.level}{confidence level for the returned confidence interval}

\item{.Object}{internal object}

\item{scores.real}{the real score}

\item{scores.vec}{all permuted scores}

\item{mat}{matrix with samples on rows, PCs in columns. 
Ordered PCs, with PC1 to the left.}

\item{classes}{vector in same order as rows in matrix}

\item{projmethod}{'pcp' or 'mlp'}

\item{iter}{integer number of iterations to be performed.}

\item{user.permutations}{user defined permutation matrix}

\item{seed}{random seed to be used by the internal permutation}

\item{df}{degrees of freedom, passed to smooth.spline}

\item{verbose}{makes function more talkative}

\item{y}{default plot param, which should be set to NULL}

\item{comparison}{Specify a comparison i.e.
("grp1 vs grp2") and plot only that comparison.}

\item{object}{ClassifiedPoints Object}
}
\value{
The permute function returns an object of class PermutationResults
}
\description{
Test how the classification performs compared to random (eg. permuted) data.
}
\details{
This is a test suit and will return a summarized object. The default of the
parameter 'iter' is set quite low, and in principle the more iterations the 
better, or until the pvalue converges to a specifc value. If no pre-permuted
data has been supplied by the user, then the internal permutation method
will perform a sampling without replacement within each dimension.
}
\examples{

#use pcp method
data(pcpMatrix)
classes <- rownames(pcpMatrix)

#run function
iterations <- 10
pe <- permute(
    mat=pcpMatrix,
    classes=classes,
    iter=iterations,
    projmethod="pcp"
)

#use mlp method
data(mlpMatrix)
classes <- rownames(mlpMatrix)
pe <- permute(
    mat=mlpMatrix,
    classes=classes,
    iter=iterations,
    projmethod="mlp"
)


#getData accessor
getData(pe)

#getData accessor specific
getData(pe, "scores.vec")

#get pvalue
pvalue(pe)

#plot result
plot(pe)

#combine three (parallell) jobs on the same matrix 
pe2 <- c(pe, pe, pe)

}
\author{
Jesper R. Gadin and Jason T. Serviss
}
\keyword{permutation}
