% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4.visCluster.R
\name{visCluster}
\alias{visCluster}
\title{using visCluster to visualize cluster results from clusterData and
enrichCluster output}
\usage{
visCluster(
  object = NULL,
  htColList = list(col_range = c(-2, 0, 2), col_color = c("#08519C", "white", "#A50F15")),
  border = TRUE,
  plotType = c("line", "heatmap", "both"),
  msCol = c("#0099CC", "grey90", "#CC3333"),
  lineSize = 0.1,
  lineCol = "grey90",
  addMline = TRUE,
  mlineSize = 2,
  mlineCol = "#CC3333",
  ncol = 4,
  ctAnnoCol = NULL,
  setMd = "median",
  textboxPos = c(0.5, 0.8),
  textboxSize = 8,
  panelArg = c(2, 0.25, 4, "grey90", NA),
  ggplotPanelArg = c(2, 0.25, 4, "grey90", NA),
  annoTermData = NULL,
  annoTermMside = "right",
  termAnnoArg = c("grey95", "grey50"),
  addBar = FALSE,
  barWidth = 8,
  textbarPos = c(0.8, 0.8),
  goCol = NULL,
  goSize = NULL,
  byGo = "anno_link",
  annoKeggData = NULL,
  annoKeggMside = "right",
  keggAnnoArg = c("grey95", "grey50"),
  addKeggBar = FALSE,
  keggCol = NULL,
  keggSize = NULL,
  byKegg = "anno_link",
  wordWrap = TRUE,
  addNewLine = TRUE,
  addBox = FALSE,
  boxCol = NULL,
  boxArg = c(0.1, "grey50"),
  addPoint = FALSE,
  pointArg = c(19, "orange", "orange", 1),
  addLine = TRUE,
  lineSide = "right",
  markGenes = NULL,
  markGenesSide = "right",
  genesGp = c("italic", 10, NA),
  termTextLimit = c(10, 18),
  mulGroup = NULL,
  lgdLabel = NULL,
  showRowNames = FALSE,
  subgroupAnno = NULL,
  annnoblockText = TRUE,
  annnoblockGp = c("white", 8),
  addSampleAnno = TRUE,
  sampleGroup = NULL,
  sampleCol = NULL,
  sampleOrder = NULL,
  clusterOrder = NULL,
  sampleCellOrder = NULL,
  heatmapAnnotation = NULL,
  columnSplit = NULL,
  clusterColumns = FALSE,
  pseudotimeCol = NULL,
  gglist = NULL,
  rowAnnotationObj = NULL,
  ...
)
}
\arguments{
\item{object}{clusterData object, default NULL.}

\item{htColList}{list of heatmap col_range and col_color, default
list(col_range = c(-2, 0, 2),col_color = c("#08519C", "white", "#A50F15")).}

\item{border}{whether add border for heatmap, default TRUE.}

\item{plotType}{the plot type to choose which incuding "line","heatmap"
and "both".}

\item{msCol}{membership line color form Mfuzz cluster method results,
default c('#0099CC','grey90','#CC3333').}

\item{lineSize}{line size for line plot, default 0.1.}

\item{lineCol}{line color for line plot, default "grey90".}

\item{addMline}{whether add median line on plot, default TRUE.}

\item{mlineSize}{median line size, default 2.}

\item{mlineCol}{median line color, default "#CC3333".}

\item{ncol}{the columns for facet plot with line plot, default 4.}

\item{ctAnnoCol}{the heatmap cluster annotation bar colors, default NULL.}

\item{setMd}{the represent line method on heatmap-line plot(mean/median),
default "median".}

\item{textboxPos}{the relative position of text in left-line plot,
default c(0.5,0.8).}

\item{textboxSize}{the text size of the text in left-line plot, default 8.}

\item{panelArg}{the settings for the left-line panel which are
panel size,gap,width,fill and col, default c(2,0.25,4,"grey90",NA).}

\item{ggplotPanelArg}{the settings for the ggplot2 object plot panel
which are
panel size,gap,width,fill and col, default c(2,0.25,4,"grey90",NA).}

\item{annoTermData}{the GO term annotation for the clusters, default NULL.}

\item{annoTermMside}{the wider GO term annotation box side, default "right".}

\item{termAnnoArg}{the settings for GO term panel annotations which
are fill and col,
default c("grey95","grey50").}

\item{addBar}{whether add bar plot for GO enrichment, default FALSE.}

\item{barWidth}{the GO enrichment bar width, default 8.}

\item{textbarPos}{the barplot text relative position, default c(0.8,0.8).}

\item{goCol}{the GO term text colors, default NULL.}

\item{goSize}{the GO term text size(numeric or "pval"), default NULL.}

\item{byGo}{the GO term text box style("anno_link" or "anno_block"),
default "anno_link".}

\item{annoKeggData}{the KEGG term annotation for the clusters, default NULL.}

\item{annoKeggMside}{the wider KEGG term annotation box side, default
"right".}

\item{keggAnnoArg}{the settings for KEGG term panel annotations which are
fill and col,
default c("grey95","grey50").}

\item{addKeggBar}{whether add bar plot for KEGG enrichment, default FALSE.}

\item{keggCol}{the KEGG term text colors, default NULL.}

\item{keggSize}{the KEGG term text size(numeric or "pval"), default NULL.}

\item{byKegg}{the KEGG term text box style("anno_link" or "anno_block"),
default "anno_link".}

\item{wordWrap}{whether wrap the text, default TRUE.}

\item{addNewLine}{whether add new line when text is long, default TRUE.}

\item{addBox}{whether add boxplot, default FALSE.}

\item{boxCol}{the box fill colors, default NULL.}

\item{boxArg}{this is related to boxplot width and border color, default
c(0.1,"grey50").}

\item{addPoint}{whether add point, default FALSE.}

\item{pointArg}{this is related to point shape,fill,color and size,
default c(19,"orange","orange",1).}

\item{addLine}{whether add line, default TRUE.}

\item{lineSide}{the line annotation side, default "right".}

\item{markGenes}{the gene names to be added on plot, default NULL.}

\item{markGenesSide}{the gene label side, default "right".}

\item{genesGp}{gene labels graphics settings, default c('italic',10,NA).}

\item{termTextLimit}{the GO term text size limit, default c(10,18).}

\item{mulGroup}{to draw multiple lines annotation, supply the groups numbers
with vector, default NULL.}

\item{lgdLabel}{the lines annotation legend labels, default NULL.}

\item{showRowNames}{whether to show row names, default FALSE.}

\item{subgroupAnno}{the sub-cluster for annotation, supply sub-cluster id,
default NULL.}

\item{annnoblockText}{whether add cluster numbers on right block
annotation, default TRUE.}

\item{annnoblockGp}{right block annotation text color and size,
default c("white",8).}

\item{addSampleAnno}{whether add column annotation, default TRUE.}

\item{sampleGroup}{the column sample groups, default NULL.}

\item{sampleCol}{column annotation colors, default NULL.}

\item{sampleOrder}{the orders for column samples, default NULL.}

\item{clusterOrder}{the row cluster orders for user's own defination,
default NULL.}

\item{sampleCellOrder}{the celltype order when input is scRNA data and
"showAverage = FALSE"
for prepareDataFromscRNA.}

\item{heatmapAnnotation}{the 'heatmapAnnotation' object from 'ComplexHeatmap'
when you have multiple annotations, default NULL.}

\item{columnSplit}{how to split the columns when supply multiple column
annotations, default NULL.}

\item{clusterColumns}{whether cluster the columns, default FALSE.}

\item{pseudotimeCol}{the branch color control for monocle input data.}

\item{gglist}{a list of ggplot object to annotate each cluster, default NULL.}

\item{rowAnnotationObj}{Row annotation for heatmap, it is a
\code{ComplexHeatmap::rowAnnotation()} object
when "markGenesSide" or ”lineSide“ is "right". Otherwise is a list of
named vectors.}

\item{...}{othe aruguments passed by Heatmap fuction.}
}
\value{
a ggplot2 or Heatmap object.
}
\description{
Visualize Clustered Gene Data Using Line Plots and Heatmaps
}
\details{
This function visualizes clustered gene expression data as line plots,
heatmaps, or
a combination of both, using the \code{ComplexHeatmap} and \code{ggplot2} frameworks.
Gene
annotations, sample annotations, and additional features like custom color
schemes
and annotations for GO/KEGG terms are supported for visualization.
}
\examples{

data("exps")

# mfuzz
cm <- clusterData(
  obj = exps,
  clusterMethod = "kmeans",
  clusterNum = 8
)

# plot
visCluster(
  object = cm,
  plotType = "line"
)

}
\author{
JunZhang
}
