% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monocleHeatmap.R
\name{plot_genes_branched_heatmap2}
\alias{plot_genes_branched_heatmap2}
\title{Create a heatmap to demonstrate the bifurcation of gene expression along two
branchs which is slightly modified in monocle2}
\usage{
plot_genes_branched_heatmap2(
  cds_subset = NULL,
  branch_point = 1,
  branch_states = NULL,
  branch_labels = c("Cell fate 1", "Cell fate 2"),
  cluster_rows = TRUE,
  hclust_method = "ward.D2",
  num_clusters = 6,
  hmcols = NULL,
  branch_colors = c("#979797", "#F05662", "#7990C8"),
  add_annotation_row = NULL,
  add_annotation_col = NULL,
  show_rownames = FALSE,
  use_gene_short_name = TRUE,
  scale_max = 3,
  scale_min = -3,
  norm_method = c("log", "vstExprs"),
  trend_formula = "~sm.ns(Pseudotime, df=3) * Branch",
  return_heatmap = FALSE,
  cores = 1,
  ...
)
}
\arguments{
\item{cds_subset}{CellDataSet for the experiment (normally only the branching
genes detected with branchTest)}

\item{branch_point}{The ID of the branch point to visualize. Can only be used
when reduceDimension is called with method = "DDRTree".}

\item{branch_states}{The two states to compare in the heatmap. Mutually
exclusive with branch_point.}

\item{branch_labels}{The labels for the branchs.}

\item{cluster_rows}{Whether to cluster the rows of the heatmap.}

\item{hclust_method}{The method used by pheatmap to perform hirearchical
clustering of the rows.}

\item{num_clusters}{Number of clusters for the heatmap of branch genes}

\item{hmcols}{The color scheme for drawing the heatmap.}

\item{branch_colors}{The colors used in the annotation strip indicating the
pre- and post-branch cells.}

\item{add_annotation_row}{Additional annotations to show for each row in the
heatmap. Must be a dataframe with one row for each row in the fData table of
cds_subset, with matching IDs.}

\item{add_annotation_col}{Additional annotations to show for each column in
the heatmap. Must be a dataframe with one row for each cell in the pData
table
of cds_subset, with matching IDs.}

\item{show_rownames}{Whether to show the names for each row in the table.}

\item{use_gene_short_name}{Whether to use the short names for each row. If
FALSE, uses row IDs from the fData table.}

\item{scale_max}{The maximum value (in standard deviations) to show in the
heatmap. Values larger than this are set to the max.}

\item{scale_min}{The minimum value (in standard deviations) to show in the
heatmap. Values smaller than this are set to the min.}

\item{norm_method}{Determines how to transform expression values prior to
rendering}

\item{trend_formula}{A formula string specifying the model used in fitting
the spline curve for each gene/feature.}

\item{return_heatmap}{Whether to return the pheatmap object to the user.}

\item{cores}{Number of cores to use when smoothing the expression curves
shown
in the heatmap.}

\item{...}{Additional arguments passed to buildBranchCellDataSet}
}
\value{
A list of heatmap_matrix (expression matrix for the branch
committment),
ph (pheatmap heatmap object),
annotation_row (annotation data.frame for the row), annotation_col
(annotation
data.frame for the column).
}
\description{
@description returns a heatmap that shows changes in both lineages at the
same
time.
It also requires that you choose a branch point to inspect.
Columns are points in pseudotime, rows are genes, and the beginning of
pseudotime is in the middle of the heatmap.
As you read from the middle of the heatmap to the right, you are following
one lineage through pseudotime. As you read left, the other.
The genes are clustered hierarchically, so you can visualize modules of
genes
that have similar lineage-dependent expression patterns.
}
\examples{
data("HSMM")
library(pheatmap)
library(VGAM)

# return plot
plot_genes_branched_heatmap2(HSMM,
                             branch_point = 1,
                             num_clusters = 4,
                             cores = 1,
                             use_gene_short_name = TRUE,
                             show_rownames = TRUE,
                             return_heatmap = TRUE)

}
