% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1.getClusters.R
\name{getClusters}
\alias{getClusters}
\title{Determine Optimal Clusters for Gene Expression or Pseudotime Data}
\usage{
getClusters(obj = NULL, ...)
}
\arguments{
\item{obj}{A data object representing the gene expression data or
pseudotime data:
\itemize{
\item If the input is a \code{cell_data_set} object (e.g., from \code{Monocle3}),
the function preprocesses the data using \code{pre_pseudotime_matrix}.
\item If the input is a numeric matrix or a \code{data.frame}, it directly uses
this data, or SummarizedExperiment object.
Default is \code{NULL}.
}}

\item{...}{Additional arguments passed to the preprocessing function
\code{pre_pseudotime_matrix} (e.g., \code{assays}, \code{normalize}, etc.).}
}
\value{
A \code{ggplot} object visualizing the Elbow plot, where:
\itemize{
\item The x-axis represents the number of clusters tested.
\item The y-axis represents the WSS for each cluster number.
}

The optimal cluster number can be visually identified at the "elbow point,
" where the
reduction in WSS diminishes sharply.

a ggplot.
}
\description{
Determine Optimal Clusters for Gene Expression or Pseudotime Data
}
\examples{

data("exps")
getClusters(obj = exps)

}
\author{
JunZhang

The \code{getClusters} function identifies the optimal number of clusters for a
given data object.
It supports multiple input types, including gene expression matrices and
objects such as \code{cell_data_set}. The function implements the Elbow method
to evaluate within-cluster sum of squares (WSS) across a range of cluster
numbers and visualizes the results.
}
