% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_communities_simmilarity.R
\name{findCommunitiesSimmilarity}
\alias{findCommunitiesSimmilarity}
\title{Find cell-group communities by constructing and clustering a directed graph using the similarity values calculated by ClusterFoldSimilarity()}
\usage{
findCommunitiesSimmilarity(similarityTable = NULL)
}
\arguments{
\item{similarityTable}{Dataframe. A table obtained from ClusterFoldSimilarity that contains the similarity values as a column "similarityValue" that represents 
the similarity of a source cluster to a target cluster.}
}
\value{
This function returns a data frame with the community that each node of the network (cell groups defined by the user) belongs to, and plots a graph in 
which the nodes are clusters from a specific dataset, the edges represent the similarity and the direction of that similarity between clusters.
\tabular{ll}{
   \code{sample} \tab The sample name. \cr
   \tab \cr
   \code{group} \tab The group/cluster from sample defined by the user. \cr
   \tab \cr
   \code{community} \tab Community group to which the sample:group belongs to.  \cr
}
}
\description{
`findCommunitiesSimmilarity()` Find communities by constructing and clustering graph using the similarity values calculated by ClusterFoldSimilarity().
}
\details{
This function will group together nodes of the network into communities using the InfoMap community detection algorithm.
}
\examples{
if (requireNamespace("Seurat") & requireNamespace("SeuratObject")){
library(ClusterFoldSimilarity)
library(Seurat)
library(SeuratObject)
# data dimensions
nfeatures <- 2000; ncells <- 400
# single-cell 1
counts <- matrix(rpois(n=nfeatures * ncells, lambda=10), nfeatures)
rownames(counts) <- paste0("gene",seq(nfeatures))
colnames(counts) <- paste0("cell",seq(ncells))
colData <- data.frame(cluster=sample(c("Cluster1","Cluster2","Cluster3"),size = ncells,replace = TRUE),
                     row.names=paste0("cell",seq(ncells)))
seu1 <- SeuratObject::CreateSeuratObject(counts = counts, meta.data = colData)
Idents(object = seu1) <- "cluster"
# single-cell 2
counts <- matrix(rpois(n=nfeatures * ncells, lambda=10), nfeatures)
rownames(counts) <- paste0("gene",seq(nfeatures))
colnames(counts) <- paste0("cell",seq(ncells))
colData <- data.frame(cluster=sample(c("Cluster1","Cluster2","Cluster3","Cluster4"),size = ncells,replace = TRUE),
                      row.names=paste0("cell",seq(ncells)))
seu2 <- SeuratObject::CreateSeuratObject(counts = counts, meta.data = colData)
Idents(object = seu2) <- "cluster"
# Create a list with the unprocessed single-cell datasets
singlecellObjectList <- list(seu1, seu2)

similarityTable <- clusterFoldSimilarity(scList = singlecellObjectList, sampleNames = c("sc1","sc2"))
head(similarityTable)
findCommunitiesSimmilarity(similarityTable=similarityTable)
}

}
\author{
Oscar Gonzalez-Velasco
}
