% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClustAll_ClustAllObject_Methods.R
\name{validateStratification}
\alias{validateStratification}
\alias{validateStratification,ClustAllObject,characterOrNA-method}
\title{Validate Stratification Results Against True Labels}
\usage{
validateStratification(Object, stratificationName)
}
\arguments{
\item{Object}{A processed \code{\link{ClustAllObject-class}} object. The object
must have been processed by \code{\link{runClustAll}} and contain validation
data (true labels).}

\item{stratificationName}{A character string specifying the name of the
stratification to be validated. This should correspond to a stratification
generated by the ClustALL algorithm and stored in the Object.}
}
\value{
A named numeric vector containing two elements:
\itemize{
  \item sensitivity: The proportion of true positive classifications
  \item specificity: The proportion of true negative classifications
}
}
\description{
This function calculates the sensitivity and specificity of a selected
stratification by comparing it to the true labels (validation data) stored
in the ClustAllObject. It provides a quantitative assessment of how well
the clustering aligns with known classifications.
}
\details{
The validateStratification function provides a crucial step in assessing the
biological or clinical relevance of clustering results:

\enumerate{
  \item Comparison Mechanism:
  \itemize{
    \item The function compares the cluster assignments of the selected stratification
      with the true labels provided in the validation data.
    \item It treats the problem as a binary classification task, considering one
      class as the "positive" class and all others as "negative".
  }

  \item Sensitivity (True Positive Rate):
  \itemize{
    \item Measures the proportion of actual positive cases that were correctly identified.
    \item Calculated as: (True Positives) / (True Positives + False Negatives)
  }

  \item Specificity (True Negative Rate):
  \itemize{
    \item Measures the proportion of actual negative cases that were correctly identified.
    \item Calculated as: (True Negatives) / (True Negatives + False Positives)
  }

  \item Interpretation:
  \itemize{
    \item Higher sensitivity indicates better identification of the positive class.
    \item Higher specificity indicates better identification of the negative classes.
    \item The function automatically adjusts calculations if necessary to ensure
      sensitivity and specificity are always higher than 0.5.
  }
}

This function is particularly useful for:
\itemize{
  \item Evaluating the clinical or biological relevance of clustering solutions
  \item Comparing different stratifications based on their alignment with known classifications
  \item Identifying stratifications that best capture known groupings in the data
  \item Providing quantitative metrics to support the selection of optimal clustering solutions
}
}
\note{
\itemize{
  \item This function requires a processed ClustAllObject with validation data.
    Ensure \code{\link{runClustAll}} has been executed and validation data
    has been added using \code{\link{addValidationData}} if not provided during
    object creation.
  \item The function assumes binary classification. For multi-class problems, it
    effectively treats one class as "positive" and all others as "negative".
  \item Stratification names can be obtained from the results of \code{\link{resStratification}}
    or by examining the names in the summary_clusters slot of the ClustAllObject.
  \item The function will stop with an error if the ClustAllObject does not contain
    validation data or if the specified stratification name is not found.
}
}
\examples{
data("BreastCancerWisconsin", package = "ClustAll")
label <- as.numeric(as.factor(wdbc$Diagnosis))
wdbc <- subset(wdbc,select=c(-ID, -Diagnosis))
wdbc <- wdbc[1:15,1:8]
label <- label[16:30]
obj_noNA <- createClustAll(data = wdbc)
\donttest{
obj_noNA1 <- runClustAll(Object = obj_noNA, threads = 1, simplify = TRUE)
resStratification(Object = obj_noNA1, population = 0.05,
                  stratification_similarity = 0.88, all = FALSE)
obj_noNA1 <- addValidationData(Object = obj_noNA1,
                               dataValidation = label)
validateStratification(obj_noNA1, "cuts_a_1")
}

}
\seealso{
\code{\link{runClustAll}}, \code{\link{resStratification}},
\code{\link{addValidationData}}, \code{\link{plotSANKEY}},
\code{\link{ClustAllObject-class}}
}
