% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClustAll_ClustAllObject_Class.R
\name{show,ClustAllObject-method}
\alias{show,ClustAllObject-method}
\title{Display Summary of ClustAllObject}
\usage{
\S4method{show}{ClustAllObject}(object)
}
\arguments{
\item{object}{A \code{\link{ClustAllObject-class}} object to be summarized.}
}
\value{
No return value, called for printing to the console.
}
\description{
This method provides a concise summary of a ClustAllObject, displaying key
information about its contents and processing status. It offers a quick
overview of the object's characteristics without the need to inspect
individual slots.
}
\details{
The show method for ClustAllObject displays the following information:

\enumerate{
  \item Object Class: Confirms that the object is of class ClustAllObject.

  \item Data Dimensions:
  \itemize{
    \item Number of variables (columns) in the processed data.
    \item Number of patients (rows) in the dataset.
  }

  \item Imputation Status:
  \itemize{
    \item Indicates whether the data has been imputed.
    \item If imputed, shows the number of imputations performed.
  }

  \item Processing Status:
  \itemize{
    \item Indicates whether the ClustALL algorithm has been run on the object.
  }

  \item Stratification Results:
  \itemize{
    \item If processed, displays the number of stratifications generated.
    \item If not processed, indicates that stratification results are not available.
  }
}

This method is particularly useful for:
\itemize{
  \item Quick verification of object contents after creation or modification.
  \item Checking the processing status before running analyses.
  \item Confirming the number of stratifications generated after running the ClustALL algorithm.
  \item Easily sharing key object characteristics in reports or discussions.
}
}
\note{
\itemize{
  \item This method is automatically called when the object name is entered at the R console.
  \item It provides a high-level overview and does not display detailed data or results.
  \item For more detailed information about specific aspects of the object, use
    dedicated accessor methods or examine individual slots directly.
}
}
\seealso{
\code{\link{createClustAll}}, \code{\link{runClustAll}},
\code{\link{ClustAllObject-class}}
}
