% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClustAll_ClustAllObject_Class.R
\name{nImputation}
\alias{nImputation}
\alias{nImputation,ClustAllObject-method}
\title{Retrieve Number of Imputations from ClustAllObject}
\usage{
nImputation(Object)
}
\arguments{
\item{Object}{A \code{\link{ClustAllObject-class}} object created by
\code{\link{createClustAll}}.}
}
\value{
An integer indicating the number of imputations performed. Returns 0
if no imputations were required or performed.
}
\description{
This method returns the number of imputations performed when creating or
processing the ClustAllObject. It provides information about how missing data
was handled in the ClustALL pipeline.
}
\details{
The nImputation method provides insight into the multiple imputation strategy
used in the ClustALL analysis pipeline:

This method is particularly useful for:
\itemize{
  \item Verifying whether imputation was performed on the dataset.
  \item Understanding the extent of the imputation process.
  \item Assessing the potential impact of imputation on subsequent analyses.
  \item Reporting the methodology used in handling missing data.
}
}
\note{
\itemize{
  \item This method returns the value stored in the 'nImputation' slot of the ClustAllObject.
  \item A return value of 0 does not necessarily mean the original data had no
    missing values; it could also indicate that imputation was explicitly skipped.
  \item The number of imputations is typically set during the creation of the
    ClustAllObject with the \code{\link{createClustAll}} function.
  \item For accessing the actual imputed datasets, use the \code{\link{dataImputed}} method.
}#'
}
\examples{
data("BreastCancerWisconsinMISSING", package = "ClustAll")
data("BreastCancerWisconsin", package = "ClustAll")
wdbc <- subset(wdbc,select=-ID)
obj_NA <- createClustAll(data = wdbcNA, colValidation = "Diagnosis",
                         dataImputed = wdbcMIDS)
nImputation(obj_NA)
}
\seealso{
\code{\link{createClustAll}}, \code{\link{dataImputed}},
\code{\link{ClustAllObject-class}}, \code{\link[mice]{mice}}
}
