% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClustAll_ClustAllObject_Class.R
\docType{class}
\name{listOrNULL-class}
\alias{listOrNULL-class}
\title{Class Union: listOrNULL}
\description{
This class union allows for flexibility in method signatures and slot
definitions by accepting either a list, NULL, or a missing value. It is
particularly useful when a slot or function parameter might contain a
list of elements but could also be empty or unspecified.
}
\details{
The listOrNULL class union includes:
\itemize{
  \item list: A standard R list object
  \item NULL: Representing an empty or unset value
  \item missing: Allowing for unspecified parameters in function calls
}

This union is useful in scenarios where:
\itemize{
  \item A function might return a list of results or NULL if no results are available
  \item A slot in an S4 object could contain a list of elements or be empty
  \item A function parameter could accept a list of options, but also work with default settings if nothing is provided
}
}
\seealso{
\code{\link{setClassUnion}}, \code{\link{ClustAllObject-class}}
}
