% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClustAll_ClustAllObject_Class.R
\name{JACCARD_DISTANCE_F}
\alias{JACCARD_DISTANCE_F}
\alias{JACCARD_DISTANCE_F,ClustAllObject-method}
\title{Retrieve Jaccard Distance Matrix for Robust Stratifications}
\usage{
JACCARD_DISTANCE_F(Object)
}
\arguments{
\item{Object}{A processed \code{\link{ClustAllObject-class}} object. The object
must have been processed by \code{\link{runClustAll}} before using this method.}
}
\value{
A square matrix where each element represents the Jaccard distance
between two robust stratifications. The row and column names correspond to
the names of the robust stratifications. Returns NULL if \code{\link{runClustAll}}
has not been executed on the object.
}
\description{
This method extracts and returns the matrix of Jaccard distances between
robust stratifications identified by the ClustALL algorithm. It provides a
quantitative measure of similarity between different clustering solutions
that have passed the bootstrapping process for population-based robustness.
}
\details{
The JACCARD_DISTANCE_F method provides crucial information about the similarity
structure of robust clustering solutions:

\enumerate{
  \item Jaccard Distance:
  \itemize{
    \item A measure of dissimilarity between sample sets, calculated as 1 minus the Jaccard coefficient.
    \item Ranges from 0 (identical stratifications) to 1 (completely different stratifications).
    \item Lower values indicate higher similarity between stratifications.
  }

  \item Matrix Structure:
  \itemize{
    \item Symmetric matrix with stratification names as row and column labels.
    \item Diagonal elements are always 0 (each stratification is identical to itself).
    \item Off-diagonal elements represent pairwise Jaccard distances.
  }

  \item Robust Stratifications:
  \itemize{
    \item Only includes stratifications that passed the bootstrapping process.
    \item Represents the most stable and reliable clustering solutions.
  }
}

This method is particularly useful for:
\itemize{
  \item Identifying groups of similar stratifications.
  \item Assessing the diversity of robust clustering solutions.
  \item Selecting representative stratifications for further analysis.
  \item Visualizing the relationships between different clustering outcomes.
  \item Input for further clustering or dimensionality reduction of stratifications.
}
}
\note{
\itemize{
  \item This method returns the data stored in the 'JACCARD_DISTANCE_F' slot of the ClustAllObject.
  \item It will return NULL if \code{\link{runClustAll}} has not been executed on the object.
  \item The Jaccard distance is calculated based on the co-occurrence of samples in clusters,
    not on the specific cluster labels.
  \item This matrix is often used as input for the \code{\link{plotJACCARD}} function
    to visualize the similarity structure of stratifications.
}
}
\examples{
data("BreastCancerWisconsin", package = "ClustAll")
wdbc <- subset(wdbc,select=c(-ID, -Diagnosis))
wdbc <- wdbc[1:15,1:8]
obj_noNA <- createClustAll(data = wdbc)
obj_noNA1 <- runClustAll(Object = obj_noNA, threads = 1, simplify = FALSE)
JACCARD_DISTANCE_F(obj_noNA1)
}
\seealso{
\code{\link{runClustAll}}, \code{\link{plotJACCARD}},
\code{\link{resStratification}}, \code{\link{ClustAllObject-class}}
}
