% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClustAll_ClustAllObject_Class.R
\docType{class}
\name{ClustAllObject-class}
\alias{ClustAllObject-class}
\title{ClustAllObject}
\value{
ClustAllObject class object.
}
\description{
The ClustAllObject class is the central data structure of the ClustAll
package, designed to store and manage data and results throughout the patient
stratification process. It encapsulates the original data, preprocessed data,
imputation results, and clustering outcomes, providing a cohesive framework
for the entire ClustALL workflow.
}
\details{
The ClustAllObject is designed to efficiently manage all aspects of the data
and results throughout the ClustAll pipeline:
\itemize{
  \item It preserves the original data while storing preprocessed versions for analysis.
  \item It handles missing data through multiple imputation, storing both original and imputed datasets.
  \item It maintains separation between data used for clustering and validation data.
  \item It stores all generated stratifications and identifies robust solutions.
  \item It provides a framework for comparing different stratification solutions.
}
This structure allows for a streamlined workflow from data input through
preprocessing, imputation (if needed), stratification, and final analysis of
results.
}
\section{Slots}{

\describe{
\item{\code{data}}{A data frame containing the preprocessed input data after applying
one-hot encoding to categorical variables and removing the validation column
(if present). This is the data used directly in the clustering process.}

\item{\code{dataOriginal}}{A data frame containing the original, unmodified input data
as provided to \code{\link{createClustAll}}. This preserves the initial state
of the data for reference and validation purposes.}

\item{\code{dataImputed}}{If imputation was applied, this slot contains a 'mids' object
from the mice package with the imputed datasets. If no imputation was performed,
this is NULL.}

\item{\code{dataValidation}}{A numeric vector containing the reference labels (true labels)
of the original dataset, if provided. These labels are used for validation purposes
and are not used in the stratification process itself. NULL if no validation data
is available.}

\item{\code{nImputation}}{An integer indicating the number of imputations to be
computed. It should be set to 0 if the dataset is already completed, or if it
the dataset has been imputed out of ClustAll framework.}

\item{\code{processed}}{A logical flag. TRUE if \code{\link{runClustAll}} has been
executed on the object, FALSE otherwise. Indicates whether the object contains
stratification results.}

\item{\code{summary_clusters}}{A list containing the resulting stratifications for each
combination of clustering methods (distance metric + clustering algorithm) and
embedding depth. This is populated after \code{\link{runClustAll}} has been
executed. NULL otherwise.}

\item{\code{JACCARD_DISTANCE_F}}{A matrix of Jaccard distances between the robust
stratifications that passed the bootstrapping process. Used to assess similarity
between different stratification solutions. NULL if \code{\link{runClustAll}}
has not been executed.}
}}

\note{
The ClustAllObject is typically created using the
\code{\link{createClustAll}} function and processed using
\code{\link{runClustAll}}. Direct manipulation of the object's slots is not
recommended as it may lead to inconsistencies in the analysis pipeline.
}
