% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessory_functions.R
\name{splitPolarities}
\alias{splitPolarities}
\title{Separate spectra with different polarities from the same run}
\usage{
splitPolarities(ms2list, polarity = c("positive", "negative"))
}
\arguments{
\item{ms2list}{A list of \code{\linkS4class{MS2spectrum}} objects as produced
by \code{\link{extractMS2spectra}}.}

\item{polarity}{The polarity of spectra to be analysed, must be
\code{"positive"} or \code{"negative"}.}
}
\value{
A list of \code{\linkS4class{MS2spectrum}} objects that contains only
    spectra with the given \code{polarity}.
}
\description{
Using \code{splitPolarities}, spectra with different polarities from the same
run can be separated, e.g. when processing spectra recorded with
polarity-switching.
}
\examples{
my_spectra <- extractMS2spectra(MSfile = system.file("extdata",
                                "PoolA_R_SE.mzXML",
                                package = "CluMSIDdata"),
                                min_peaks = 4, RTlims = c(0,5))

my_positive_spectra <- splitPolarities(my_spectra, "positive")

}
