% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessory_functions.R
\name{findNL}
\alias{findNL}
\title{Find spectra that contain a specific neutral loss}
\usage{
findNL(featlist, mz, tolerance = 1e-05)
}
\arguments{
\item{featlist}{a list that contains only objects of class
\code{\linkS4class{MS2spectrum}}}

\item{mz}{The mass-to-charge ratio of the neutral loss of interest.}

\item{tolerance}{The \emph{m/z} tolerance for the neutral loss search.
Default is \code{1E-05}, i.e. +/- 10ppm.}
}
\value{
If the respective neutral loss is only found in one spectrum, the
    output is an object of class \code{\linkS4class{MS2spectrum}}; if it is
    found in more than one spectrum, the output is a list of
    \code{\linkS4class{MS2spectrum}} objects.
}
\description{
\code{findNL} is used to find spectra that contain a specific neutral loss.
Its sister function is \code{\link{findFragment}}, which finds specific
fragment ions. Both functions work analogous to \code{\link{getSpectrum}}.
}
\examples{
load(file = system.file("extdata",
    "annotatedSpeclist.RData",
    package = "CluMSIDdata"))
findNL(annotatedSpeclist, 212.009)

}
