% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distancematrix_mds.R
\name{MDSplot}
\alias{MDSplot}
\title{Multidimensional scaling of spectral similarity data}
\usage{
MDSplot(distmat, interactive = FALSE, highlight_annotated = FALSE, ...)
}
\arguments{
\item{distmat}{A distance matrix as generated by
\code{\link{distanceMatrix}}.}

\item{interactive}{Logical, defaults to \code{FALSE}. If \code{TRUE}, an
interactive visualisation is generated using \pkg{plotly}.}

\item{highlight_annotated}{Logical, defaults to \code{FALSE}.
If \code{TRUE}, points for features for which an annotation was added
before using \code{\link{distanceMatrix}} are highlighted by red colour,
while other points are grey in the MDS plot.}

\item{...}{Additional arguments passed to \code{geom_point()},
e.g. \code{pch}, \code{size} or \code{alpha}.}
}
\value{
An MDS plot generated with the help of
    \code{\link[stats]{cmdscale}},
    \code{\link[ggplot2]{ggplot}} and, if interactive,
    \code{\link[plotly]{ggplotly}}.
}
\description{
\code{MDSplot()} is used to generate multidimensional scaling plots from
spectral similarity data. An interactive visualisation can be produced using
\pkg{plotly}.
}
\examples{
load(file = system.file("extdata",
    "distmat.RData",
    package = "CluMSIDdata"))

MDSplot(distmat, highlight_annotated = TRUE)

}
