% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate.R
\name{featureList}
\alias{featureList}
\title{Generate a \code{data.frame} with feature information from list of
\code{MS2spectrum} objects}
\usage{
featureList(featlist)
}
\arguments{
\item{featlist}{A list of \code{MS2spectrum} objects as produced by
\code{extractMS2spectra} and \code{mergeSpecList}}
}
\value{
A \code{data.frame} that contains feature ID, precurosur \emph{m/z}
    (if available) and retention time
}
\description{
\code{featureList} generates a \code{data.frame} that contains feature ID,
precurosur \emph{m/z} and retention time for all features contained in a
list of \code{MS2spectrum} objects as produced by \code{extractMS2spectra}
and \code{mergeSpecList}. \code{featureList} is used internally by
\code{\link{writeFeaturelist}}.
}
\details{
Although originally designed for lists of \code{MS2spectrum}
    objects, the function also works with lists of \code{pseudospectrum}
    objects. In this case, \code{NA} is given for precursor \emph{m/z}.
}
\examples{
load(file = system.file("extdata",
    "featlist.RData",
    package = "CluMSIDdata"))

pre_anno <- featureList(featlist)

}
