% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{style_BSgenome}
\alias{style_BSgenome}
\title{Convert a BSgenome from the UCSC to the Ensembl style}
\usage{
style_BSgenome(
  UCSC_BSgenome = NULL,
  genome_version = "GRCh38",
  seqname_alias = data.frame(ucsc = paste0("chr", c(seq_len(22), "X", "Y", "M")), ensembl
    = c(seq_len(22), "X", "Y", "MT"))
)
}
\arguments{
\item{UCSC_BSgenome}{An object of the \link[BSgenome:BSgenome-class]{BSgenome::BSgenome} in the UCSC
style, such as BSgenome.Hsapiens.UCSC.hg38.}

\item{genome_version}{A character(1), specifying the genome version, such as
"GRCh38".}

\item{seqname_alias}{A data frame or a tab-delimited file to a data frame,
with two columns: \code{ucsc} and \code{ensembl} for UCSC-style seqnames and
Ensembl-style seqnames, respectively.}
}
\value{
An object of the \link[BSgenome:BSgenome-class]{BSgenome::BSgenome} in the Ensembl style,
such as BSgenome.Dvirilis.Ensembl.dvircaf1.
}
\description{
Convert a BSgenome from the UCSC style to the Ensembl style, changing
"chrM" to "MT", removing the "chr" prefix from chromosome/scaffold seqnames,
only keeping seqnames in the primary genome assembly, and changing the genome
version name form the UCSC name to the Ensembl name, such as from "hg38" to
"GRCh38".
}
\examples{
\dontshow{if (require("BSgenome.Hsapiens.UCSC.hg38")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ucsc_BSgenome <- BSgenome.Hsapiens.UCSC.hg38
ucsc_seqnames <-
    seqnames(ucsc_BSgenome)[!grepl("_alt|fix|hap\\\\d+",
                            seqnames(ucsc_BSgenome))]

## Wierd: BSgenome.Hsapiens.UCSC.hg19 has both chrM and chrMT for
## mitochondrial genome. renomve chrMT.

if (all(c("chrM", "chrMT") \%in\% ucsc_seqnames)) {
    ucsc_seqnames <- ucsc_seqnames[!ucsc_seqnames \%in\% "chrMT"]
}

ensembl_seqnames <- gsub(
    "^chr", "",
    gsub(
        "chrM$", "MT",
        gsub(
            "v", ".",
            gsub("_random|chr[^_]+_", "", ucsc_seqnames)
        )
    )
)
## for BSgenome.Hsapiens.UCSC.hg19, scaffold seqnames start with lower case,
## should be changed to upper case. For example, change "gl000231" to
## "GL000231". Add a suffix ".1" to these scaffold seqnames.

seqname_alias <- data.frame(ucsc = ucsc_seqnames,
                            ensembl = ensembl_seqnames)

bsgenome <- style_BSgenome(
    UCSC_BSgenome = ucsc_BSgenome,
    genome_version = "GRCh38",
    seqname_alias = seqname_alias
)
\dontshow{\}) # examplesIf}
}
