% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6_class.R
\name{create_summarizedcounts}
\alias{create_summarizedcounts}
\title{Create an object of SummarizedCounts}
\usage{
create_summarizedcounts(lib_strand = 0, colData = NULL)
}
\arguments{
\item{lib_strand}{An integer(1), specifying the library's strandedness. It
has three possible values:
\itemize{
\item 0: unstranded, the default;
\item 1: stranded, read 1 (or single-end read) comes from the forward strand;
\item 2: reversely stranded, read 1 (or single-end read) comes from the
reverse strand
For more details, See
https://sailfish.readthedocs.io/en/master/library_type.html.
}}

\item{colData}{A data frame with rows corresponding to samples. For
unstranded RNA-seq data, it at least contains the following columns:
\code{sample_name}, \code{BAM_file}, \code{group}, \code{salmon_quant_file}, and \code{batch} if
the data were generated in more than one batches. For stranded RNA-seq
data, an extra column, \code{salmon_quant_file_opposite_strand}, should be
included.}
}
\value{
An object of \link{SummarizedCounts}, which is used to store
summary output from featureCounts and tximport, and store gDNA-corrected
expression data.
}
\description{
Set up an analysis by creating an object of \link{SummarizedCounts}, which
is used to store summary output from featureCounts and tximport, and store
gDNA-corrected expression data. This is a convenience wrapper for
\code{SummarizedCounts$new()}
}
\examples{
in_dir <- system.file("extdata", package = "CleanUpRNAseq")
BAM_file <- dir(in_dir, ".bam$", full.name = TRUE)
salmon_quant_file <- dir(in_dir, ".sf$", full.name = TRUE)
sample_name = gsub(".+/(.+?).srt.bam", "\\\\1", BAM_file)
salmon_quant_file_opposite_strand <- salmon_quant_file
col_data <- data.frame(sample_name = sample_name,
                       BAM_file = BAM_file,
                       salmon_quant_file = salmon_quant_file,
                       salmon_quant_file_opposite_strand =
                           salmon_quant_file_opposite_strand,
                       group = c("CD1N", "CD1P"))

sc <- create_summarizedcounts(lib_strand = 0, colData = col_data)

}
