% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correction_methods.R
\name{correct_stranded}
\alias{correct_stranded}
\title{Correct for gDNA contamination in stranded libraries}
\usage{
correct_stranded(SummarizedCounts = NULL)
}
\arguments{
\item{SummarizedCounts}{An object of \link{SummarizedCounts}..}
}
\value{
A list of of matrices of gene-level abundance, counts, and length.
See \code{\link[tximport:tximport]{tximport::tximport()}}. The count matrix is corrected for DNA
contamination and rounded into integers.
\describe{
\item{abundance}{A numeric matrix containing corrected abundance (TPM) for
each gene of each sample}
\item{counts}{An \emph{integer} matrix containing \emph{corrected} read count for
each gene of each sample}
\item{length}{A numeric matrix containing length (bp) for each gene of
each sample}
}
}
\description{
Correct for gDNA contamination in stranded libraries based on Salmon
quantitation using the real and opposite library strandedness information
}
\examples{
lib_strand <- 1
col_data_f <- system.file("extdata", "example.colData.txt",
                         package = "CleanUpRNAseq")
col_data <- read.delim(col_data_f, as.is = TRUE)
## create fake bam files
tmp_dir <- tempdir()
bamfiles <- gsub(".+/", "", col_data$BAM_file)
null <- lapply(file.path(tmp_dir, bamfiles), file.create)
## create fake quant.sf files
quant_sf <- file.path(tmp_dir, gsub(".srt.bam$",
                                    "quant.sf",
                                    bamfiles))
null <- lapply(quant_sf, file.create)
col_data$BAM_file <- file.path(tmp_dir, bamfiles)
col_data$salmon_quant_file <- quant_sf

## pretend this is stranded RA=NA-seq data
col_data$salmon_quant_file_opposite_strand <- quant_sf

sc <- create_summarizedcounts(lib_strand, col_data)

data("feature_counts_list")
data("salmon_quant")

sc$set_feature_counts(feature_counts_list)
sc$set_salmon_quant(salmon_quant)
sc$set_salmon_quant_opposite(salmon_quant)
stranded_correction <- correct_stranded(SummarizedCounts = sc)

}
