% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correction_methods.R
\name{correct_GC}
\alias{correct_GC}
\title{Correct DNA contamination considering GC-bias effect}
\usage{
correct_GC(
  SummarizedCounts = NULL,
  gene_gc = NULL,
  intergenic_gc = NULL,
  plot = FALSE
)
}
\arguments{
\item{SummarizedCounts}{An object of \link{SummarizedCounts}..}

\item{gene_gc}{A data frame or matrix with two columns: gc_content in
proportion between 0 and 1, and width in basepair, containing
GC-content and total exon lengths of each gene. An output of the
\code{\link[=calc_gene_gc]{calc_gene_gc()}} function.}

\item{intergenic_gc}{A data frame or matrix with two columns: gc_content in
proportion between 0 and 1, and width in basepair, containing
GC-content and lengths of each intergenic region, such as an output from
the \code{\link[=calc_region_gc]{calc_region_gc()}} function.}

\item{plot}{A logical(1) vector, specifying whether to output a panel of
scatter plot showing a bi-variate distribution of GC content and count per
base of intergenic regions in each sample. Default is TRUE.}
}
\value{
A data frame containing corrected count for each gene (row) of each
sample (column).
}
\description{
Correct DNA contamination considering GC-bias effect on fragment
amplification. Intergenic regions are binned based on their GC content
ranging from 0 to 100\%, with a bin size of 5\%. Per gene DNA contamination
is estimated as the product of count per base in a GC content matching bin
of intergenic regions and the total collapsed exons of a gene and is
subtracted away from the gene count matrix.
}
\examples{
lib_strand <- 0
col_data_f <- system.file("extdata", "example.colData.txt",
                         package = "CleanUpRNAseq")
col_data <- read.delim(col_data_f, as.is = TRUE)
## create fake bam files
tmp_dir <- tempdir()
bamfiles <- gsub(".+/", "", col_data$BAM_file)
null <- lapply(file.path(tmp_dir, bamfiles), file.create)
## create fake quant.sf files
quant_sf <- file.path(tmp_dir, gsub(".srt.bam$",
                                    "quant.sf",
                                    bamfiles))
null <- lapply(quant_sf, file.create)
col_data$BAM_file <- file.path(tmp_dir, bamfiles)
col_data$salmon_quant_file <- quant_sf

## pretend this is stranded RA=NA-seq data
col_data$salmon_quant_file_opposite_strand <- quant_sf

sc <- create_summarizedcounts(lib_strand, col_data)

data("feature_counts_list")
data("salmon_quant")

sc$set_feature_counts(feature_counts_list)
sc$set_salmon_quant(salmon_quant)
sc$set_salmon_quant_opposite(salmon_quant)

data("gene_GC")
data("intergenic_GC")
gc_bias_corrected_counts <-
    correct_GC(
        SummarizedCounts = sc,
        gene_gc = gene_GC,
        intergenic_gc = intergenic_GC,
        plot = FALSE
    )

}
