% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{calc_region_gc}
\alias{calc_region_gc}
\title{Calculate GC content of genomic regions}
\usage{
calc_region_gc(region = NULL, BSgenome = NULL, batch_size = 2000)
}
\arguments{
\item{region}{A data frame containing the columns: "Chr", "Start", "End",
and "Strand", such as a data frame contained in a sublist named
\emph{intergenic_region} from the output of the \code{\link[=get_saf]{get_saf()}} function,
or a object of \link[GenomicRanges:GRangesList-class]{GenomicRanges::GRangesList} or
\link[GenomicRanges:GRanges-class]{GenomicRanges::GRanges}.}

\item{BSgenome}{An object of \link[BSgenome:BSgenome-class]{BSgenome::BSgenome}. Make sure the
chromosome names (aka seqnames) in the BSgenome object match those in the
\emph{region_saf} data frame and the \emph{region_gr} object.}

\item{batch_size}{An integer(1) vector, specifying how many regions are
processed each batch.}
}
\value{
A data.frame contains two columns: gc_content and width.
\describe{
\item{gc_content}{GC contents (proportion) of genomic regions}
\item{width}{widths of genomic regions}
}
}
\description{
Calculate GC content of genomic regions
}
\examples{
\dontshow{if (require("BSgenome.Hsapiens.UCSC.hg38")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ucsc_BSgenome <- BSgenome.Hsapiens.UCSC.hg38
ucsc_seqnames <-
    seqnames(ucsc_BSgenome)[!grepl(
        "_alt|fix|hap\\\\d+",
        seqnames(ucsc_BSgenome)
    )]

## Wierd: BSgenome.Hsapiens.UCSC.hg19 has both chrM and chrMT for
## mitochondrial genome. renomve chrMT.

if (all(c("chrM", "chrMT") \%in\% ucsc_seqnames)) {
    ucsc_seqnames <- ucsc_seqnames[!ucsc_seqnames \%in\% "chrMT"]
}

ensembl_seqnames <- gsub(
    "^chr", "",
    gsub(
        "chrM$", "MT",
        gsub(
            "v", ".",
            gsub("_random|chr[^_]+_", "", ucsc_seqnames)
        )
    )
)
## for BSgenome.Hsapiens.UCSC.hg19, scaffold seqnames start with lower case,
## should be changed to upper case. For example, change "gl000231" to
## "GL000231". Add a suffix ".1" to these scaffold seqnames.

seqname_alias <- data.frame(ucsc = ucsc_seqnames,
                            ensembl = ensembl_seqnames)
bsgenome <- style_BSgenome(
    UCSC_BSgenome = BSgenome.Hsapiens.UCSC.hg38,
    genome_version = "GRCh38",
    seqname_alias = seqname_alias
)
region <- data.frame(
    GeneID = as.character(seq_len(10)),
    Chr = rep("1", 10),
    Start = 100000 * (seq_len(10)),
    End = 100000 * (seq_len(10)) + 1000,
    Strand = rep("+", 10)
)

gc_contents <- calc_region_gc(
    region = region,
    BSgenome = bsgenome,
    batch_size = 2000
)
\dontshow{\}) # examplesIf}
}
