% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{calc_gene_gc}
\alias{calc_gene_gc}
\title{Calculate GC content of genes}
\usage{
calc_gene_gc(ensdb_sqlite = NULL, BSgenome = NULL, batch_size = 2000)
}
\arguments{
\item{ensdb_sqlite}{A character(1) specifying a path to an SQLite file to
store the an object of the \link[ensembldb:EnsDb-class]{ensembldb::EnsDb} or an object of the
\link[ensembldb:EnsDb-class]{ensembldb::EnsDb}.}

\item{BSgenome}{An object of \link[BSgenome:BSgenome-class]{BSgenome::BSgenome}. Make sure the
chromosome names (aka seqnames) in the BSgenome object match those in the
\link[ensembldb:EnsDb-class]{ensembldb::EnsDb} specified by \emph{ensdb_sqlite}.}

\item{batch_size}{An integer(1) vector, specifying how many regions are
processed each batch.}
}
\value{
A data frame contains two columns: gc_content and width.
\describe{
\item{gc_content}{GC contents (proportion) of genes}
\item{width}{widths of genes}
}
}
\description{
Calculate GC content of all genes based on sequences of collapsed exons of
each gene.
}
\examples{
\dontshow{if (interactive() && require("BSgenome.Hsapiens.UCSC.hg38")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
require("ensembldb")
ucsc_BSgenome <- BSgenome.Hsapiens.UCSC.hg38
ucsc_seqnames <-
    seqnames(ucsc_BSgenome)[!grepl("_alt|fix|hap\\\\d+",
                            seqnames(ucsc_BSgenome))]

## Wierd: BSgenome.Hsapiens.UCSC.hg19 has both chrM and chrMT for
## mitochondrial genome. renomve chrMT.

if (all(c("chrM", "chrMT") \%in\% ucsc_seqnames)) {
    ucsc_seqnames <- ucsc_seqnames[!ucsc_seqnames \%in\% "chrMT"]
}

ensembl_seqnames <- gsub(
    "^chr", "",
    gsub(
        "chrM$", "MT",
        gsub(
            "v", ".",
            gsub("_random|chr[^_]+_", "", ucsc_seqnames)
        )
    )
)
## for BSgenome.Hsapiens.UCSC.hg19, scaffold seqnames start with lower case,
## should be changed to upper case. For example, change "gl000231" to
## "GL000231". Add a suffix ".1" to these scaffold seqnames.

seqname_alias <- data.frame(ucsc = ucsc_seqnames,
                            ensembl = ensembl_seqnames)

bsgenome <- style_BSgenome(
    UCSC_BSgenome = ucsc_BSgenome,
    genome_version = "GRCh38",
    seqname_alias = seqname_alias
)


tmp_dir <- tempdir()
gtf <- system.file("extdata", "example.gtf.gz",
                   package = "CleanUpRNAseq")
hs_ensdb_sqlite <-
    ensembldb::ensDbFromGtf(
        gtf = gtf,
        outfile = file.path(tmp_dir, "EnsDb.hs.v110.sqlite"),
        organism = "Homo_Sapiens",
        genomeVersion = "GRCh38",
        version = 110
    )
gene_gc <- calc_gene_gc(
    ensdb_sqlite = hs_ensdb_sqlite,
    BSgenome = bsgenome,
    batch_size = 2000
)
\dontshow{\}) # examplesIf}
}
