% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{ModellingParams}
\alias{ModellingParams}
\alias{ModellingParams-class}
\title{Parameters for Data Modelling Specification}
\usage{
ModellingParams(
  balancing = c("downsample", "upsample", "none"),
  transformParams = NULL,
  selectParams = SelectParams("t-test"),
  trainParams = TrainParams("DLDA"),
  predictParams = PredictParams("DLDA"),
  doImportance = FALSE
)
}
\arguments{
\item{balancing}{Default: \code{"downsample"}. A character value specifying what kind
of class balancing to do, if any.}

\item{transformParams}{Parameters used for feature transformation inside of C.V.
specified by a \code{\link{TransformParams}} instance. Optional, can be \code{NULL}.}

\item{selectParams}{Parameters used during feature selection specified
by a \code{\link{SelectParams}} instance.  By default, parameters for selection
based on differences in means of numeric data. Optional, can be \code{NULL}.}

\item{trainParams}{Parameters for model training specified by a \code{\link{TrainParams}} instance.
By default, uses diagonal LDA.}

\item{predictParams}{Parameters for model training specified by a \code{\link{PredictParams}} instance.
By default, uses diagonal LDA.}

\item{doImportance}{Default: \code{FALSE}. Whether or not to carry out removal of each feature, one at a time, which
was chosen and then retrain and model and predict the test set, to measure the change in performance metric. Can
also be set to TRUE, if required. Modelling run time will be noticeably longer.}
}
\description{
Collects and checks necessary parameters required for data modelling. Apart
from data transfomation that needs to be done within cross-validation (e.g.
subtracting each observation from training set mean), feature selection, model training and
prediction, this container also stores a setting for class imbalance
rebalancing.
}
\examples{

  #if(require(sparsediscrim))
  #{
     ModellingParams() # Default is differences in means selection and DLDA.
     ModellingParams(selectParams = NULL, # No feature selection before training.
                     trainParams = TrainParams("randomForest"),
                     predictParams = PredictParams("randomForest"))
  #}
}
\author{
Dario Strbenac
}
