% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{igraphClustering}
\alias{igraphClustering}
\title{igraphClustering}
\usage{
igraphClustering(
  sce,
  metadata = "SNF_W",
  method = c("louvain", "leiden", "walktrap", "spinglass", "optimal", "leading_eigen",
    "label_prop", "fast_greedy", "edge_betweenness"),
  ...
)
}
\arguments{
\item{sce}{A singlecellexperiment object}

\item{metadata}{indicates the meta data name of affinity matrix
to virsualise}

\item{method}{A character indicates the method for finding communities
from igraph. Default is louvain clustering.}

\item{...}{Other inputs for the igraph functions}
}
\value{
A vector indicates the membership (clustering) results
}
\description{
A function to perform igraph clustering
}
\examples{

data(sce_control_subset, package = "CiteFuse")
sce_control_subset <- CiteFuse(sce_control_subset)
SNF_W_louvain <- igraphClustering(sce_control_subset,
method = "louvain")

}
