% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage.R
\name{plot_coverage}
\alias{plot_coverage}
\alias{plot.CircSeqAlignTkCoverage}
\title{Visualize alignment coverage}
\usage{
plot_coverage(x, read_lengths = NULL, fill = "read_length", scale_fun = NULL)

\method{plot}{CircSeqAlignTkCoverage}(x, ...)
}
\arguments{
\item{x}{A \code{\link{CircSeqAlignTkCoverage-class}} object generated by
the \code{\link{calc_coverage}} function.}

\item{read_lengths}{Numeric numbers to specify the lengths of reads
targeted for visualization. If \code{NULL} (default),
plot the alignment coverage of reads with all lengths.}

\item{fill}{Specify \code{NULL} or \code{read_length}.
If \code{read_length} is specified, then color the area chart
according to the read length.}

\item{scale_fun}{Set \code{log10} or \code{log} to plot the alignment coverage
in logarithmic scale.}

\item{...}{Other graphical parameters.}
}
\value{
An object of ggplot2.
}
\description{
This function visualizes the alignment coverage using an area chart.
By default, the upper and lower directions of the y-axis represent
the alignment coverage of the reads
aligned in the forward and reverse strands, respectively.
}
\examples{
output_dpath <- tempdir()
genome_seq <- system.file(package="CircSeqAlignTk", "extdata", "FR851463.fa")
fq <- system.file(package="CircSeqAlignTk", "extdata", "srna.fq.gz")
ref_index <- build_index(input = genome_seq,
                         output = file.path(output_dpath, 'index'))
aln <- align_reads(input = fq, index = ref_index,
                   output = file.path(output_dpath, 'align_results'))

alncov <- calc_coverage(aln)
plot(alncov)
}
\seealso{
\code{\link{CircSeqAlignTkCoverage-class}}, \code{\link{calc_coverage}}
}
