% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{merge.CircSeqAlignTkSim}
\alias{merge.CircSeqAlignTkSim}
\title{Merge multiple synthetic datasets}
\usage{
\method{merge}{CircSeqAlignTkSim}(..., output = NULL, overwrite = TRUE)
}
\arguments{
\item{...}{CircSeqAlignTkSim class objects.}

\item{output}{A file path to store the synthetic reads in FASTQ format file.
The extension should be one of \code{.fq}, \code{.fastq}.
Note that to compress the FASTQ format file, add \code{.gz} or \code{.gzip} to the
extension (e.g., \code{.fq.gz}, \code{.fq.gzip}).}

\item{overwrite}{Overwrite the existing files if \code{TRUE}.}
}
\value{
A \code{\link{CircSeqAlignTkSim-class}} object.
}
\description{
Merge multiple synthetic datasets generated by \code{\link{generate_reads}}.
}
\details{
Merge multiple synthetic datasets generated by \code{\link{generate_reads}}
into one dataset.
}
\examples{
output_dpath <- tempdir()

sim_params_1 <- data.frame(length = c(21, 22), prob = c(0.5, 0.4))
sim_1 <- generate_reads(n = 5e2,
                        output = file.path(output_dpath, 'sample1.fq.gz'),
                        srna_length = sim_params_1)

sim_params_2 <- data.frame(length = c(19, 20, 23), prob = c(0.2, 0.7, 0.1))
sim_2 <- generate_reads(n = 5e2,
                        output = file.path(output_dpath, 'sample2.fq.gz'),
                        srna_length = sim_params_2)

sim <- merge(sim_1, sim_2, output = file.path(output_dpath, 'sample.fq.gz'))
}
\seealso{
\code{\link{CircSeqAlignTkSim-class}}, \code{\link{generate_reads}}
}
