% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing_filtering_reduction.R
\name{preprocess_TFIDF}
\alias{preprocess_TFIDF}
\title{Preprocess scExp - TF-IDF}
\usage{
preprocess_TFIDF(scExp, scale = 10000, log = TRUE)
}
\arguments{
\item{scExp}{A SingleCellExperiment Object}

\item{scale}{A numeric to multiply the matrix in order to have human readeable
numbers. Has no impact on the downstream analysis}

\item{log}{Wether to use neperian log on the TF-IDF normalized data or not.}
}
\value{
A SingleCellExperiment object.
}
\description{
Preprocess scExp - TF-IDF
}
\examples{
raw <- create_scDataset_raw()
scExp = create_scExp(raw$mat, raw$annot)
scExp = preprocess_TFIDF(scExp)
head(SingleCellExperiment::normcounts(scExp))

}
