% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_pie_most_contributing_chr}
\alias{plot_pie_most_contributing_chr}
\title{Pie chart of top contribution of chromosomes in the 100 most contributing
features to PCA
#'}
\usage{
plot_pie_most_contributing_chr(
  scExp,
  component = "Component_1",
  n_top_bot = 100
)
}
\arguments{
\item{scExp}{A SingleCellExperiment containing "PCA" in reducedDims and gene
annotation in rowRanges}

\item{component}{The name of the component of interest}

\item{n_top_bot}{An integer number of top and bot regions to plot (100)}
}
\value{
A pie chart showing the distribution of chromosomes in the top
features with the largest absolute value in the component of interest
}
\description{
Pie chart of top contribution of chromosomes in the 100 most contributing
features to PCA
#'
}
\examples{
data(scExp)
 plot_pie_most_contributing_chr(scExp, component = "Component_1")
}
