% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy_number.R
\name{get_most_variable_cyto}
\alias{get_most_variable_cyto}
\title{Retrieve the cytobands with the most variable fraction of reads}
\usage{
get_most_variable_cyto(scExp, top = 50)
}
\arguments{
\item{scExp}{A SingleCellExperiment with "cytoBand" reducedDim slot filled.}

\item{top}{Number of cytobands to return (50).}
}
\value{
A data.frame of the top variable cytoBands and their variance
}
\description{
Given a SingleCellExperiment object with the slot "cytoBand" containing the
fraction of reads in each cytoband, calculates the variance of each cytoband
and returns a data.frame with the top variables cytobands. Most cytobands are
expected to be unchanged between normal and tumor samples, therefore focusing
on the top variable cytobands enable to focus on the most interseting
regions.
}
\examples{

data("scExp")
scExp = calculate_cyto_mat(scExp, ref_genome="hg38")
get_most_variable_cyto(scExp, top=50)
 
}
