% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing_filtering_reduction.R
\name{filter_scExp}
\alias{filter_scExp}
\title{Filter cells and features}
\usage{
filter_scExp(
  scExp,
  min_cov_cell = 1600,
  quant_removal = 95,
  min_count_per_feature = 10,
  verbose = TRUE
)
}
\arguments{
\item{scExp}{A SingleCellExperiment object.}

\item{min_cov_cell}{Minimum counts for each cell. (1600)}

\item{quant_removal}{Centile of cell counts above which cells are removed.
(95)}

\item{min_count_per_feature}{Minimum number of reads per feature (10).}

\item{verbose}{(TRUE)}
}
\value{
Returns a filtered SingleCellExperiment object.
}
\description{
Function to filter out cells & features from SingleCellExperiment based on
total count per cell, number of cells 'ON' in features and top covered cells
that might be doublets.
}
\examples{

raw <- create_scDataset_raw()
scExp = create_scExp(raw$mat, raw$annot)
scExp. = filter_scExp(scExp)

# No feature filtering (all features are valuable)
scExp. = filter_scExp(scExp,min_count_per_feature=30)

# No cell filtering (all features are valuable)
scExp. = filter_scExp(scExp,min_cov_cell=0,quant_removal=100)

}
