% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage.R
\name{count_coverage}
\alias{count_coverage}
\title{Create a smoothed and normalized coverage track from a BAM file and
given a bin GenomicRanges object (same as deepTools bamCoverage)}
\usage{
count_coverage(
  input,
  format = "BAM",
  bins,
  canonical_chr,
  norm_factor,
  n_smoothBin = 5,
  ref = "hg38",
  read_size = 101,
  original_bins = NULL
)
}
\arguments{
\item{input}{Either a named list of character vector of path towards
single-cell BED files or a sparse raw matrix of small bins (<<500bp). If
a named list specifying scBEDn the names MUST correspond to the 'sample_id'
column in your SingleCellExperiment object. The single-cell BED files names MUST
match the  barcode names in your SingleCellExperiment (column 'barcode'). The
scBED files can be gzipped or not.}

\item{format}{File format, either "BAM" or "BED"}

\item{bins}{A GenomicRanges object of binned genome}

\item{canonical_chr}{GenomicRanges of the chromosomes to read the BAM file.}

\item{norm_factor}{Then number of cells or total number of reads in the given
sample, for normalization.}

\item{n_smoothBin}{Number of bins left and right to smooth the signal.}

\item{ref}{Genomic reference}

\item{read_size}{Length of the reads}

\item{original_bins}{Original bins GenomicRanges in case the format is raw

matrix.}
}
\value{
A binned GenomicRanges that can be readily exported into bigwig file.
}
\description{
Normalization is CPM, smoothing is done by averaging on n_smoothBin regions
left and right of any given region.
}
