% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAllPeakSequence.R
\name{getAllPeakSequence}
\alias{getAllPeakSequence}
\title{Obtain genomic sequences around the peaks}
\usage{
getAllPeakSequence(
  myPeakList,
  upstream = 200L,
  downstream = upstream,
  genome,
  AnnotationData
)
}
\arguments{
\item{myPeakList}{An object of \link[GenomicRanges:GRanges-class]{GRanges}:
See example below}

\item{upstream}{upstream offset from the peak start, e.g., 200}

\item{downstream}{downstream offset from the peak end, e.g., 200}

\item{genome}{BSgenome object or mart object. Please refer to
available.genomes in BSgenome package and useMart in bioMaRt package for
details}

\item{AnnotationData}{GRanges object with annotation information.}
}
\value{
\link[GenomicRanges:GRanges-class]{GRanges} with slot start holding
the start position of the peak, slot end holding the end position of the
peak, slot rownames holding the id of the peak and slot seqnames holding the
chromosome where the peak is located. In addition, the following variables
are included: \item{upstream}{upstream offset from the peak start}
\item{downstream}{downstream offset from the peak end} \item{sequence}{the
sequence obtained}
}
\description{
Obtain genomic sequences around the peaks leveraging the BSgenome and
biomaRt package
}
\examples{

#### use Annotation data from BSgenome
peaks <- GRanges(seqnames=c("NC_008253", "NC_010468"),
                 IRanges(start=c(100, 500), end=c(300, 600), 
                         names=c("peak1", "peak2")))
library(BSgenome.Ecoli.NCBI.20080805)
seq <- getAllPeakSequence(peaks, upstream=20, downstream=20, genome=Ecoli)
write2FASTA(seq, file="test.fa")

}
\references{
Durinck S. et al. (2005) BioMart and Bioconductor: a powerful
link between biological biomarts and microarray data analysis.
Bioinformatics, 21, 3439-3440.
}
\author{
Lihua Julie Zhu, Jianhong Ou
}
\keyword{misc}
