% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binOverRegions.R
\name{binOverRegions}
\alias{binOverRegions}
\title{coverage of chromosome regions}
\usage{
binOverRegions(
  cvglists,
  TxDb,
  upstream.cutoff = 1000L,
  downstream.cutoff = upstream.cutoff,
  nbinsCDS = 100L,
  nbinsUTR = 20L,
  nbinsUpstream = 20L,
  nbinsDownstream = nbinsUpstream,
  includeIntron = FALSE,
  minCDSLen = nbinsCDS,
  minUTRLen = nbinsUTR,
  maxCDSLen = Inf,
  maxUTRLen = Inf
)
}
\arguments{
\item{cvglists}{A list of \link[IRanges:AtomicList-class]{SimpleRleList} or
\link[IRanges:AtomicList-class]{RleList}. It represents the coverage for
samples.}

\item{TxDb}{An object of \code{\link[GenomicFeatures:TxDb-class]{TxDb}}.  It
is used for extracting the annotations.}

\item{upstream.cutoff, downstream.cutoff}{cutoff length for upstream or
downstream of transcript.}

\item{nbinsCDS, nbinsUTR, nbinsUpstream, nbinsDownstream}{The number of bins
for CDS, UTR, upstream and downstream.}

\item{includeIntron}{A logical value which indicates including intron or
not.}

\item{minCDSLen, minUTRLen}{minimal length of CDS or UTR of transcript.}

\item{maxCDSLen, maxUTRLen}{maximal length of CDS or UTR of transctipt.}
}
\description{
calculate the coverage of 5'UTR, CDS and 3'UTR per transcript per bin.
}
\examples{

if(Sys.getenv("USER")=="jou"){
path <- system.file("extdata", package="ChIPpeakAnno")
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
library(rtracklayer)
files <- dir(path, "bigWig")
if(.Platform$OS.type != "windows"){
cvglists <- lapply(file.path(path, files), import,
                   format="BigWig", as="RleList")
names(cvglists) <- sub(".bigWig", "", files)
d <- binOverRegions(cvglists, TxDb.Hsapiens.UCSC.hg19.knownGene)
plotBinOverRegions(d)
}
}

}
\seealso{
\link{binOverGene}, \link{plotBinOverRegions}
}
\author{
Jianhong Ou
}
