% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdp.R
\name{bdp}
\alias{bdp}
\title{obtain the peaks near bi-directional promoters}
\usage{
bdp(peaks, annoData, maxgap = 2000L, ...)
}
\arguments{
\item{peaks}{peak list, \link[GenomicRanges:GRanges-class]{GRanges} object}

\item{annoData}{annotation data, \link{annoGR} object}

\item{maxgap}{maxgap between peak and TSS}

\item{...}{Not used.}
}
\value{
Output is a list of GRanges object of the peaks near bi-directional
promoters.
}
\description{
Obtain the peaks near bi-directional promoters. Also output percent of peaks
near bi-directional promoters.
}
\examples{

  if(interactive() || Sys.getenv("USER")=="jou"){
    library(ensembldb)
    library(EnsDb.Hsapiens.v75)
    data("myPeakList")
    annoGR <- annoGR(EnsDb.Hsapiens.v75)
    seqlevelsStyle(myPeakList) <- seqlevelsStyle(annoGR)
    ChIPpeakAnno:::bdp(myPeakList, annoGR)
  }

}
\seealso{
See Also as \code{\link{annoPeaks}}, \code{\link{annoGR}}
}
\author{
Jianhong Ou
}
\keyword{misc}
