% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addAncestors.R
\name{addAncestors}
\alias{addAncestors}
\title{Add GO IDs of the ancestors for a given vector of GO ids}
\usage{
addAncestors(go.ids, ontology = c("bp", "cc", "mf"))
}
\arguments{
\item{go.ids}{A matrix with 4 columns: first column is GO IDs and 4th 
column is entrez IDs.}

\item{ontology}{bp for biological process, cc for cellular component and 
mf for molecular function.}
}
\value{
A vector of GO IDs containing the input GO IDs with the GO IDs of 
their ancestors added.
}
\description{
Add GO IDs of the ancestors for a given vector of GO IDs 
leveraging GO.db
}
\examples{
go.ids = cbind(c("GO:0008150", "GO:0005576", "GO:0003674"),
               c("ND", "IDA", "ND"), 
               c("BP", "BP", "BP"), 
               c("1", "1", "1"))
library(GO.db)
addAncestors(go.ids, ontology="bp")
}
\author{
Lihua Julie Zhu
}
\keyword{misc}
