% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IDRfilter.R
\name{IDRfilter}
\alias{IDRfilter}
\title{Filter peaks by IDR (irreproducible discovery rate)}
\usage{
IDRfilter(
  peaksA,
  peaksB,
  bamfileA,
  bamfileB,
  maxgap = -1L,
  minoverlap = 0L,
  singleEnd = TRUE,
  IDRcutoff = 0.01,
  ...
)
}
\arguments{
\item{peaksA, peaksB}{peaklist, \link[GenomicRanges:GRanges-class]{GRanges}
object.}

\item{bamfileA, bamfileB}{file path of bam files.}

\item{maxgap, minoverlap}{Used in the internal call to \code{findOverlaps()}
to detect overlaps. See
\code{?\link[IRanges:findOverlaps-methods]{findOverlaps}} in the
\pkg{IRanges} package for a description of these arguments.}

\item{singleEnd}{(Default TRUE) A logical indicating if reads are single or
paired-end.}

\item{IDRcutoff}{If the IDR no less than IDRcutoff, the peak will be
removed.}

\item{...}{Not used.}
}
\value{
An object GRanges
}
\description{
Using IDR to assess the consistency of replicate experiments and obtain a
high-confidence single set of peaks
}
\examples{

  if(interactive()){
    path <- system.file("extdata", "reads", package="MMDiffBamSubset")
    if(file.exists(path)){
            bamfileA <- file.path(path, "reads", "WT_2.bam")
            bamfileB <- file.path(path, "reads", "Resc_2.bam")
            WT.AB2.Peaks <- file.path(path, "peaks", "WT_2_Macs_peaks.xls")
            Resc.AB2.Peaks <- file.path(path, "peaks",
                                       "Resc_2_Macs_peaks.xls")
            peaksA=toGRanges(WT.AB2.Peaks, format="MACS")
            peaksB=toGRanges(Resc.AB2.Peaks, format="MACS")
            library(idr)
            library(DelayedArray)
            IDRfilter(peaksA, peaksB,
                        bamfileA, bamfileB)
    }
  }

}
\references{
Li, Qunhua, et al. "Measuring reproducibility of high-throughput
experiments." The annals of applied statistics (2011): 1752-1779.
}
\author{
Jianhong Ou
}
\keyword{misc}
