#' Ste12-binding sites from biological replicate 1 in yeast (see reference)
#' 
#' Ste12-binding sites from biological replicate 1 in yeast (see reference)
#' 
#' 
#' @name Peaks.Ste12.Replicate1
#' @docType data
#' @format GRanges with slot names containing the ID of peak as character, slot
#' start containing the start position of the peak, slot end containing the end
#' position of the peak and space containing the chromosome where the peak is
#' located.
#' @references Philippe Lefranois, Ghia M Euskirchen, Raymond K Auerbach, Joel
#' Rozowsky, Theodore Gibson, Christopher M Yellman, Mark Gerstein and Michael
#' Snyder (2009) Efficient yeast ChIP-Seq using multiplex short-read DNA
#' sequencing BMC Genomics 10:37
#' @keywords datasets
#' @examples
#' 
#' data(Peaks.Ste12.Replicate1)
#' Peaks.Ste12.Replicate1
#' 
"Peaks.Ste12.Replicate1"

#' Ste12-binding sites from biological replicate 2 in yeast (see reference)
#' 
#' Ste12-binding sites from biological replicate 2 in yeast (see reference)
#' 
#' 
#' @name Peaks.Ste12.Replicate2
#' @docType data
#' @format GRanges with slot names containing the ID of peak as character, slot
#' start containing the start position of the peak, slot end containing the end
#' position of the peak and space containing the chromosome where the peak is
#' located.
#' @references Philippe Lefranois, Ghia M Euskirchen, Raymond K Auerbach, Joel
#' Rozowsky, Theodore Gibson, Christopher M Yellman, Mark Gerstein and Michael
#' Snyder (2009) Efficient yeast ChIP-Seq using multiplex short-read DNA
#' sequencing BMC Genomics 10:37doi:10.1186/1471-2164-10-37
#' @source http://www.biomedcentral.com/1471-2164/10/37
#' @keywords datasets
#' @examples
#' 
#' data(Peaks.Ste12.Replicate2)
#' Peaks.Ste12.Replicate2
"Peaks.Ste12.Replicate2"

#' Ste12-binding sites from biological replicate 3 in yeast (see reference)
#' 
#' Ste12-binding sites from biological replicate 3 in yeast (see reference)
#' 
#' 
#' @name Peaks.Ste12.Replicate3
#' @docType data
#' @format GRanges with slot names containing the ID of peak as character, slot
#' start containing the start position of the peak, slot end containing the end
#' position of the peak and space containing the chromosome where the peak is
#' located.
#' @references Philippe Lefranois, Ghia M Euskirchen, Raymond K Auerbach, Joel
#' Rozowsky, Theodore Gibson, Christopher M Yellman, Mark Gerstein and Michael
#' Snyder (2009) Efficient yeast ChIP-Seq using multiplex short-read DNA
#' sequencing BMC Genomics 10:37doi:10.1186/1471-2164-10-37
#' @source http://www.biomedcentral.com/1471-2164/10/37
#' @keywords datasets
#' @examples
#' 
#' data(Peaks.Ste12.Replicate3)
#' Peaks.Ste12.Replicate3
#' 
"Peaks.Ste12.Replicate3"
