% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_summaryPlots.R
\name{regionCompplot}
\alias{regionCompplot}
\title{regionCompplot}
\usage{
regionCompplot(..., names.input = NULL, depth.values = seq_len(15))
}
\arguments{
\item{...}{a \code{list} of \code{ExoData} objects, or several 
\code{ExoData} objects by themselves.}

\item{names.input}{a character vector with the names to use in the
plot. If it is empty \code{regionCompplot} is going to create the names
as the names of the list when they are available or is going to 
name them as Sample: 1 ,... , Sample: k.}

\item{depth.values}{a numeric vector indicating the regions with depth 
less or equal to, that are going to be filtered out. The defaulta values 
are \code{seq_len(50)}.}
}
\value{
A \code{ggplot2} object with the Region Composition plot.
}
\description{
\code{regionCompplot} returns a \code{ggplot} object with the 
Region Composition plot to analyze strand imbalance in ChIP-exo data.
}
\examples{
data(exoExample)
regionCompplot(exoExample)
}
