% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_subsampling.R
\name{ExoDataSubsampling}
\alias{ExoDataSubsampling}
\title{ExoDataSubsampling}
\usage{
ExoDataSubsampling(file = NULL, reads = NULL, sample.depth = NULL,
  height = 1, nregions = 1000, ntimes = 1000, verbose = TRUE,
  save.reads = FALSE, mc.cores = getOption("mc.cores", 2L))
}
\arguments{
\item{file}{a character value with location of the bam file with the aligned
reads.}

\item{reads}{a \code{GAlignments} object with the aligned reads of a ChIP-exo
sample. It is meant to be used instead of \code{file}.}

\item{sample.depth}{a numeric vector with the number of reads to be sampled.}

\item{height}{a numeric value indicating the value used to slice the coverage
of the experiment into a set of regions.}

\item{nregions}{a numeric value indicating the number of regions sampled to 
estimate the quality parameter distributions. The default value is 1e3.}

\item{ntimes}{a numeric value indicating the number of times that regions are 
sampled to estimate the quality parameter distributions. The default value
is 1e2.}

\item{verbose}{a logical value indicating if the user want to receive progress
details. The default value is FALSE.}

\item{save.reads}{a logical value to indicate if the reads are stored in the
\code{ExoData} object. The default value is \code{FALSE}.}

\item{mc.cores}{a numeric value with the number of cores to use,
i.e. at most how many child processes will be run simultaneously.}
}
\value{
It returns an \code{ExoData} object with the regions obtained after
partitioning the genome and the summary statistics for each region. If the
\code{save.reads} parameter is \code{TRUE} then it contains a \code{GRanges}
object with the reads of the ChIP-exo experiment.
}
\description{
\code{ExoDataSubsampling} samples \code{sample.reads} from the ChIP-exo experiment and creates a list
of \code{ExoData} objects
}
\examples{

files <- list.files(system.file("extdata",package = "ChIPexoQualExample"),
    full.names = TRUE)
sample.depth <- seq(1e5,2e5,5e4)
ExoDataSubsampling(file = files[5],sample.depth = sample.depth)

}
