% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_blacklist.R
\name{ExoDataBlacklist}
\alias{ExoDataBlacklist}
\title{ExoDataBlacklist}
\usage{
ExoDataBlacklist(exo, blacklist, which.param = "beta1", nregions = NULL,
  ntimes = NULL)
}
\arguments{
\item{exo}{a \code{ExoData} object.}

\item{blacklist}{a \code{GRanges} object with the blacklisted regions or a \code{character} indicating 
which of the blacklist included in \code{ChIPexoQual} to use.}

\item{which.param}{a character value with either \code{"beta1"} or 
\code{"beta2"} that determines which parameters in the model 
depth_i ~ uniquePos_i + width_i to plot. The default value is 
\code{"beta1"}.}

\item{nregions}{a numeric value indicating the number of regions sampled to 
estimate the quality parameter distributions. The default value is extracted from \code{exo}.}

\item{ntimes}{a numeric value indicating the number of times that regions are 
sampled to estimate the quality parameter distributions. The default value
is extracted from \code{object}.}
}
\value{
A \code{ggplot} object with a boxplot that compares the quality scores distribution when the regions
overlap a pre-defined collection of blacklists.
}
\description{
\code{ExoDataBlacklist} separates the regions in an \code{ExoData} object by overlapping them
with a set of blacklisted regions and calculates the quality parameters in both collections of 
islands.
}
\examples{
data(exoExample)
data(blacklists)
ExoDataBlacklist(exoExample,blacklists[["mm9"]],ntimes = 10,nregions = 500)


}
