% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_summaryPlots.R
\name{ARCvURCplot}
\alias{ARCvURCplot}
\title{ARCvURCplot}
\usage{
ARCvURCplot(..., names.input = NULL, both.strand = FALSE)
}
\arguments{
\item{...}{a \code{list} of \code{ExoData} objects, or several 
\code{ExoData} objects by themselves.}

\item{names.input}{a character vector with the names to use in the
plot. If it is empty \code{ARCvURCplot} is going to create the names
as the names of the list when they are available or is going to 
name them as Sample: 1 ,... , Sample: k.}

\item{both.strand}{A logical value indicating if the \code{DataFrame} 
contains only regions with reads aligned to both strand or all. The default
value is \code{FALSE}.}
}
\value{
A \code{ggplot2} object with the ARC vs URC plot.
}
\description{
\code{ARCvURCplot} returns a \code{ggplot} object with the ARC vs
URC plot to analyze enrichment and library complexity in ChIP-exo data.
}
\examples{
data(exoExample)
ARCvURCplot(exoExample)
}
