% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group.R
\name{GetGroupGeneDistance}
\alias{GetGroupGeneDistance}
\alias{GetGroupGeneDistance.Seurat}
\alias{GetGroupGeneDistance.SingleCellExperiment}
\title{Centroids-Genes distances}
\usage{
GetGroupGeneDistance(X, group.by, reduction, dims, features)

\method{GetGroupGeneDistance}{Seurat}(
  X,
  group.by = NULL,
  reduction = "mca",
  dims = seq(50),
  features = NULL
)

\method{GetGroupGeneDistance}{SingleCellExperiment}(
  X,
  group.by,
  reduction = "MCA",
  dims = seq(50),
  features = NULL
)
}
\arguments{
\item{X}{Seurat or SingleCellExperiment object, alternatively a matrix.}

\item{group.by}{column name of meta.data (Seurat) or ColData (SingleCellExperiment)}

\item{reduction}{Which dimensionality reduction to use, must be based on MCA.}

\item{dims}{A vector of integers indicating which dimensions to use with reduction embeddings and loadings for distance calculation.}

\item{features}{A character vector of features name to subset feature coordinates for distance calculation.}
}
\value{
Distance Matrix between groups (column) and genes (row)
}
\description{
Distance calculation between genes and group of cells centroids.
}
