% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otherMetrics.R
\name{entropy}
\alias{entropy}
\title{entropy}
\usage{
entropy(
  sce,
  group,
  k,
  dim_red = "PCA",
  assay_name = "logcounts",
  n_dim = 10,
  res_name = NULL
)
}
\arguments{
\item{sce}{\code{SingleCellExperiment} object, with the integrated data.}

\item{group}{Character. Name of group/batch variable.
Needs to be one of \code{names(colData(sce))}.}

\item{k}{Numeric. Number of k-nearest neighbours (knn) to use.}

\item{dim_red}{Character. Name of embeddings to use as subspace for distance
distributions. Default is "PCA".}

\item{assay_name}{Character. Name of the assay to use for PCA.
Only relevant if no existing 'dim_red' is provided.
Must be one of \code{names(assays(sce))}. Default is "logcounts".}

\item{n_dim}{Numeric. Number of dimensions to include to define the subspace.}

\item{res_name}{Character. Appendix of the result score's name
(e.g. method used to combine batches).}
}
\value{
A \code{SingleCellExperiment} with the entropy score within colData.
}
\description{
entropy
}
\details{
The entropy function calculates the Shannon entropy of the group
variable within each cell's k-nearest neighbourhood.
For balanced batches a Shannon entropy close to 1 indicates high randomness
and mixing. For unbalanced batches entropy should be interpreted with
caution, but could work as a relative measure in a comparative setting.
}
\examples{
library(SingleCellExperiment)
sim_list <- readRDS(system.file("extdata/sim50.rds", package = "CellMixS"))
sce <- sim_list[[1]][, c(1:15, 400:420, 16:30)]

sce <- entropy(sce, "batch", k = 20)

}
