% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_check.R
\name{check_class}
\alias{check_class}
\alias{is_one_of}
\alias{is_any_of}
\alias{is_all_of}
\title{Check class of object}
\usage{
is_one_of(x, classes)

is_any_of(x, classes)

is_all_of(x, classes)
}
\arguments{
\item{x}{the object to check}

\item{classes}{the vector of strings of class names}
}
\value{
boolean value for the result of the check
}
\description{
Check an object against a vector of class names. Testing if they
  match any or all of the classes. For is_all_of, the object needs to be at
  least every class specified, but it can have addition classes and still
  pass the check.
}
\examples{
is_one_of(1, c("numeric", "logical")) # TRUE
is_one_of(1, c("character", "logical")) # FALSE

is_all_of(1, c("numeric", "logical")) # FALSE
is_all_of(tibble::tibble(), c("tbl", "data.frame")) # TRUE
}
\keyword{internal}
